/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.settings;

import io.github.steaf23.bingoreloaded.data.BingoMessage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BingoGamemode implements ComponentLike
{
    REGULAR("regular", BingoMessage.MODE_REGULAR.asPhrase(new Component[0]), TextColor.fromHexString("#309f14")),
    LOCKOUT("lockout", BingoMessage.MODE_LOCKOUT.asPhrase(new Component[0]), TextColor.fromHexString("#8138d9")),
    COMPLETE("complete", BingoMessage.MODE_COMPLETE.asPhrase(new Component[0]), TextColor.fromHexString("#3d6fe3")),
    HOTSWAP("hotswap", BingoMessage.MODE_HOTSWAP.asPhrase(new Component[0]), TextColor.fromHexString("#dd5e20"));

    private final String configName;
    private final Component displayName;
    private final TextColor color;

    private BingoGamemode(String configName, Component displayName, TextColor color) {
        this.configName = configName;
        this.displayName = displayName;
        this.color = color;
    }

    public static BingoGamemode fromDataString(String data) {
        return BingoGamemode.fromDataString(data, false);
    }

    @Nullable
    public static BingoGamemode fromDataString(String data, boolean strict) {
        for (BingoGamemode mode : BingoGamemode.values()) {
            if (!mode.configName.equals(data)) continue;
            return mode;
        }
        if (strict) {
            return null;
        }
        return REGULAR;
    }

    public String getDataName() {
        return this.configName;
    }

    @Override
    @NotNull
    public Component asComponent() {
        return this.displayName.color(this.color);
    }

    public TextColor getColor() {
        return this.color;
    }
}

