/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.settings;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.player.EffectOptionFlags;
import io.github.steaf23.bingoreloaded.settings.BingoGamemode;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import java.util.EnumSet;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import org.jetbrains.annotations.NotNull;

public record BingoSettings(String card, BingoGamemode mode, CardSize size, int seed, PlayerKit kit, EnumSet<EffectOptionFlags> effects, int maxTeamSize, CountdownType countdownType, int countdownDuration, int hotswapGoal, boolean expireHotswapTasks, int completeGoal, boolean differentCardPerTeam) {
    public boolean useCountdown() {
        return this.countdownType == CountdownType.TIME_LIMIT || this.countdownType == CountdownType.DURATION;
    }

    public boolean useScoreAsWinCondition() {
        return this.countdownType == CountdownType.DISABLED || this.countdownType == CountdownType.TIME_LIMIT;
    }

    public static enum CountdownType implements Keyed
    {
        DISABLED(BingoReloaded.resourceKey("countdown_type.disabled")),
        DURATION(BingoReloaded.resourceKey("countdown_type.duration")),
        TIME_LIMIT(BingoReloaded.resourceKey("countdown_type.time_limit"));

        private final Key key;

        private CountdownType(Key key) {
            this.key = key;
        }

        @Override
        @NotNull
        public Key key() {
            return this.key;
        }

        public static CountdownType fromNamespace(Key key) {
            if (key.equals(DISABLED.key())) {
                return DISABLED;
            }
            if (key.equals(DURATION.key())) {
                return DURATION;
            }
            if (key.equals(TIME_LIMIT.key())) {
                return TIME_LIMIT;
            }
            ConsoleMessenger.bug("Unimplemented Countdown type when converting namespace", CountdownType.class);
            return DISABLED;
        }
    }
}

