/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.settings;

import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.data.BingoSettingsData;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gameloop.vote.VoteTicket;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.player.EffectOptionFlags;
import io.github.steaf23.bingoreloaded.settings.BingoGamemode;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import java.util.EnumSet;
import java.util.Objects;

public class BingoSettingsBuilder {
    private final BingoSession session;
    private String card;
    private BingoGamemode mode;
    private CardSize cardSize;
    private int cardSeed;
    private PlayerKit kit;
    private EnumSet<EffectOptionFlags> effects;
    private int maxTeamSize;
    private BingoSettings.CountdownType countdownType;
    private int countdownGameDuration;
    private int hotswapGoal;
    private boolean expireHotswapTasks;
    private int completeGoal;
    private boolean differentCardPerTeam;

    public BingoSettingsBuilder(BingoSession session) {
        this.session = session;
        BingoSettings def = new BingoSettingsData().getDefaultSettings();
        if (def == null) {
            ConsoleMessenger.error("Could not find default settings, make sure you have at least 1 existing settings preset and its set to be the default settings!");
            return;
        }
        this.card = def.card();
        this.mode = def.mode();
        this.cardSize = def.size();
        this.cardSeed = def.seed();
        this.kit = def.kit();
        this.effects = def.effects();
        this.maxTeamSize = def.maxTeamSize();
        this.countdownGameDuration = def.countdownDuration();
        this.countdownType = def.countdownType();
        this.hotswapGoal = def.hotswapGoal();
        this.completeGoal = def.completeGoal();
        this.differentCardPerTeam = def.differentCardPerTeam();
        this.expireHotswapTasks = def.expireHotswapTasks();
    }

    public void fromOther(BingoSettings settings) {
        this.card = settings.card();
        this.mode = settings.mode();
        this.cardSize = settings.size();
        this.cardSeed = settings.seed();
        this.kit = settings.kit();
        this.effects = settings.effects();
        this.maxTeamSize = settings.maxTeamSize();
        this.countdownGameDuration = settings.countdownDuration();
        this.countdownType = settings.countdownType();
        this.hotswapGoal = settings.hotswapGoal();
        this.completeGoal = settings.completeGoal();
        this.differentCardPerTeam = settings.differentCardPerTeam();
        this.expireHotswapTasks = settings.expireHotswapTasks();
        this.settingsUpdated();
    }

    public BingoSettingsBuilder applyVoteResult(VoteTicket voteResult) {
        CardSize newCardsize;
        String newCard;
        PlayerKit newKit;
        BingoSettingsBuilder resultBuilder = new BingoSettingsBuilder(this.session);
        resultBuilder.fromOther(this.view());
        BingoGamemode newMode = VoteTicket.CATEGORY_GAMEMODE.getValidResultOrNull(voteResult);
        if (newMode != null) {
            resultBuilder.mode = newMode;
        }
        if ((newKit = VoteTicket.CATEGORY_KIT.getValidResultOrNull(voteResult)) != null) {
            resultBuilder.kit = newKit;
        }
        if ((newCard = VoteTicket.CATEGORY_CARD.getValidResultOrNull(voteResult)) != null) {
            resultBuilder.card = newCard;
        }
        if ((newCardsize = VoteTicket.CATEGORY_CARDSIZE.getValidResultOrNull(voteResult)) != null) {
            resultBuilder.cardSize = newCardsize;
        }
        return resultBuilder;
    }

    public BingoSettingsBuilder card(String card) {
        if (!Objects.equals(this.card, card)) {
            this.card = card;
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettingsBuilder mode(BingoGamemode mode) {
        if (this.mode != mode) {
            this.mode = mode;
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettingsBuilder cardSize(CardSize cardSize) {
        if (this.cardSize != cardSize) {
            this.cardSize = cardSize;
            this.completeGoal = cardSize.fullCardSize;
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettingsBuilder cardSeed(int cardSeed) {
        if (this.cardSeed != cardSeed) {
            this.cardSeed = cardSeed;
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettingsBuilder kit(PlayerKit kit) {
        if (this.kit != kit) {
            this.kit = kit;
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettingsBuilder effects(EnumSet<EffectOptionFlags> effects) {
        this.effects = effects;
        this.settingsUpdated();
        return this;
    }

    public BingoSettingsBuilder toggleEffect(EffectOptionFlags effect, boolean enable) {
        if (enable) {
            this.effects.add(effect);
        } else {
            this.effects.remove((Object)effect);
        }
        this.settingsUpdated();
        return this;
    }

    public BingoSettingsBuilder maxTeamSize(int maxTeamSize) {
        if (this.maxTeamSize != maxTeamSize) {
            this.maxTeamSize = maxTeamSize;
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettingsBuilder countdownType(BingoSettings.CountdownType countdownType) {
        if (this.countdownType != countdownType) {
            this.countdownType = countdownType;
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettingsBuilder countdownGameDuration(int countdownGameDuration) {
        if (this.countdownGameDuration != countdownGameDuration) {
            this.countdownGameDuration = countdownGameDuration;
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettingsBuilder expireHotswapTasks(boolean expireHotswapTasks) {
        if (this.expireHotswapTasks != expireHotswapTasks) {
            this.expireHotswapTasks = expireHotswapTasks;
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettingsBuilder hotswapGoal(int hotswapGoal) {
        if (this.hotswapGoal != hotswapGoal) {
            this.hotswapGoal = hotswapGoal;
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettingsBuilder completeGoal(int completeGoal) {
        if (this.completeGoal != completeGoal) {
            this.completeGoal = Math.min(completeGoal, this.cardSize.fullCardSize);
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettingsBuilder differentCardPerTeam(boolean value) {
        if (this.differentCardPerTeam != value) {
            this.differentCardPerTeam = value;
            this.settingsUpdated();
        }
        return this;
    }

    public BingoSettings view() {
        return new BingoSettings(this.card, this.mode, this.cardSize, this.cardSeed, this.kit, this.effects, this.maxTeamSize, this.countdownType, this.countdownGameDuration, this.hotswapGoal, this.expireHotswapTasks, this.completeGoal, this.differentCardPerTeam);
    }

    public void settingsUpdated() {
        this.session.onSettingUpdated(this.view());
    }
}

