/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.settings;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.CustomKitData;
import io.github.steaf23.bingoreloaded.data.DefaultKitData;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.item.SerializableItem;
import io.github.steaf23.bingoreloaded.player.EffectOptionFlags;
import io.github.steaf23.bingoreloaded.settings.CustomKit;
import java.util.EnumSet;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.Nullable;

public enum PlayerKit {
    HARDCORE("hardcore", BingoMessage.KIT_HARDCORE_NAME.asPhrase(new Component[0]), EnumSet.noneOf(EffectOptionFlags.class)),
    NORMAL("normal", BingoMessage.KIT_NORMAL_NAME.asPhrase(new Component[0]), EnumSet.of(EffectOptionFlags.SPEED, EffectOptionFlags.NO_FALL_DAMAGE)),
    OVERPOWERED("overpowered", BingoMessage.KIT_OVERPOWERED_NAME.asPhrase(new Component[0]), EnumSet.allOf(EffectOptionFlags.class)),
    RELOADED("reloaded", BingoMessage.KIT_RELOADED_NAME.asPhrase(new Component[0]), EnumSet.allOf(EffectOptionFlags.class)),
    CUSTOM_1("custom_1", Component.text("CUSTOM 1"), EnumSet.noneOf(EffectOptionFlags.class)),
    CUSTOM_2("custom_2", Component.text("CUSTOM 2"), EnumSet.noneOf(EffectOptionFlags.class)),
    CUSTOM_3("custom_3", Component.text("CUSTOM 3"), EnumSet.noneOf(EffectOptionFlags.class)),
    CUSTOM_4("custom_4", Component.text("CUSTOM 4"), EnumSet.noneOf(EffectOptionFlags.class)),
    CUSTOM_5("custom_5", Component.text("CUSTOM 5"), EnumSet.noneOf(EffectOptionFlags.class));

    public static final Key WAND_COOLDOWN_GROUP;
    public static final ItemTemplate WAND_ITEM;
    public static final ItemTemplate CARD_ITEM_RENDERABLE;
    public static final ItemTemplate CARD_ITEM;
    public static final ItemTemplate VOTE_ITEM;
    public static final ItemTemplate TEAM_ITEM;
    public final String configName;
    private final Component displayName;
    public final EnumSet<EffectOptionFlags> defaultEffects;
    private static final DefaultKitData DEFAULT_KIT_DATA;
    private static final CustomKitData CUSTOM_KIT_DATA;

    private PlayerKit(String configName, Component displayName, EnumSet<EffectOptionFlags> defaultEffects) {
        this.configName = configName;
        this.displayName = displayName;
        this.defaultEffects = defaultEffects;
    }

    public Component getDisplayName() {
        if (this.isCustomKit()) {
            return CUSTOM_KIT_DATA.getCustomKit(this).name();
        }
        return this.displayName;
    }

    public List<SerializableItem> getItems(TextColor teamColor, ServerSoftware server) {
        List<Object> items = switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2, 3 -> {
                Record kit = DEFAULT_KIT_DATA.getKit(this);
                if (kit != null) {
                    yield ((DefaultKitData.Kit)kit).items();
                }
                yield List.of();
            }
            case 4, 5, 6, 7, 8 -> {
                Record kit = CUSTOM_KIT_DATA.getCustomKit(this);
                if (kit != null) {
                    yield ((CustomKit)kit).items();
                }
                yield List.of();
            }
        };
        return items.stream().map(item -> new SerializableItem(item.slot(), server.colorItemStack(item.stack(), teamColor))).toList();
    }

    public int getCardSlot() {
        if (this.isCustomKit()) {
            return CUSTOM_KIT_DATA.getCustomKit(this).cardSlot();
        }
        return 40;
    }

    public boolean isCustomKit() {
        return PlayerKit.customKits().contains((Object)this);
    }

    public boolean isValid() {
        return !this.isCustomKit() || PlayerKit.customKits().contains((Object)this) && CUSTOM_KIT_DATA.getCustomKit(this) != null;
    }

    public static PlayerKit fromConfig(String name) {
        return PlayerKit.fromConfig(name, false);
    }

    @Nullable
    public static PlayerKit fromConfig(String name, boolean strict) {
        if (name == null) {
            return strict ? null : HARDCORE;
        }
        return switch (name.toLowerCase()) {
            case "normal" -> NORMAL;
            case "overpowered" -> OVERPOWERED;
            case "reloaded" -> RELOADED;
            case "custom", "custom_1" -> CUSTOM_1;
            case "custom_2" -> CUSTOM_2;
            case "custom_3" -> CUSTOM_3;
            case "custom_4" -> CUSTOM_4;
            case "custom_5" -> CUSTOM_5;
            default -> strict ? null : HARDCORE;
        };
    }

    public static List<PlayerKit> customKits() {
        return List.of(CUSTOM_1, CUSTOM_2, CUSTOM_3, CUSTOM_4, CUSTOM_5);
    }

    static {
        WAND_COOLDOWN_GROUP = BingoReloaded.resourceKey("wand_cooldown");
        WAND_ITEM = new ItemTemplate(ItemType.of("minecraft:warped_fungus_on_a_stick"), (Component)BingoMessage.WAND_ITEM_NAME.asPhrase(new Component[0]).color(NamedTextColor.DARK_PURPLE).decorate(TextDecoration.BOLD, TextDecoration.ITALIC), BingoMessage.WAND_ITEM_DESC.asMultiline(new Component[0])).addEnchantment(Key.key("minecraft:unbreaking"), 3).setCompareKey("wand");
        CARD_ITEM_RENDERABLE = new ItemTemplate(ItemType.of("minecraft:filled_map"), (Component)BingoMessage.CARD_ITEM_NAME.asPhrase(new Component[0]).color(NamedTextColor.DARK_PURPLE).decorate(TextDecoration.BOLD, TextDecoration.ITALIC), BingoMessage.CARD_ITEM_DESC.asMultiline(new Component[0])).setGlowing(true).setCompareKey("card");
        CARD_ITEM = new ItemTemplate(ItemType.of("minecraft:flower_banner_pattern"), (Component)BingoMessage.CARD_ITEM_NAME.asPhrase(new Component[0]).color(NamedTextColor.DARK_PURPLE).decorate(TextDecoration.BOLD, TextDecoration.ITALIC), BingoMessage.CARD_ITEM_DESC.asMultiline(new Component[0])).setGlowing(true).setCompareKey("card");
        VOTE_ITEM = new ItemTemplate(ItemType.of("minecraft:emerald"), (Component)BingoMessage.VOTE_ITEM_NAME.asPhrase(new Component[0]).color(NamedTextColor.DARK_PURPLE).decorate(TextDecoration.BOLD, TextDecoration.ITALIC), BingoMessage.VOTE_ITEM_DESC.asMultiline(new Component[0])).setCompareKey("vote").addEnchantment(Key.key("minecraft:vanishing_curse"), 1);
        TEAM_ITEM = new ItemTemplate(ItemType.of("minecraft:white_glazed_terracotta"), (Component)BingoMessage.TEAM_ITEM_NAME.asPhrase(new Component[0]).color(NamedTextColor.DARK_PURPLE).decorate(TextDecoration.BOLD, TextDecoration.ITALIC), BingoMessage.TEAM_ITEM_DESC.asMultiline(new Component[0])).setCompareKey("team").addEnchantment(Key.key("minecraft:vanishing_curse"), 1);
        DEFAULT_KIT_DATA = new DefaultKitData();
        CUSTOM_KIT_DATA = new CustomKitData();
    }
}

