/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.tasks;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.api.network.packets.DataWriter;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataStorage;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.tasks.GameTaskSerializer;
import io.github.steaf23.bingoreloaded.tasks.data.ItemTask;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import io.github.steaf23.bingoreloaded.util.timer.GameTimer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameTask {
    private BingoParticipant completedBy;
    private BingoTeam completedByTeam;
    public long completedAt;
    private boolean voided;
    public TaskData data;

    public GameTask(@NotNull TaskData data) {
        this.data = data;
        this.completedBy = null;
        this.completedByTeam = null;
        this.voided = false;
        this.completedAt = -1L;
    }

    public static GameTask simpleItemTask(ItemType material, int count) {
        return new GameTask(new ItemTask(material, count));
    }

    public void setVoided(boolean value) {
        if (this.isCompleted()) {
            return;
        }
        this.voided = value;
    }

    public boolean isVoided() {
        return this.voided;
    }

    public boolean isCompleted() {
        return this.completedBy != null || this.completedByTeam != null;
    }

    public ItemTemplate toItem(CardDisplayInfo displayInfo) {
        ItemTemplate item;
        if (this.isVoided()) {
            item = new ItemTemplate(ItemType.of("structure_void"), null, new Component[0]);
            Component[] addedDesc = BingoMessage.VOIDED.asMultiline(NamedTextColor.DARK_GRAY, new Component[0]);
            item.setName(this.getName());
            item.setLore(addedDesc);
            item.setGlowing(true);
        } else if (this.isCompleted()) {
            ItemType completeMaterial = ItemType.of("barrier");
            String timeString = GameTimer.getTimeAsString(this.completedAt);
            Component[] desc = BingoMessage.COMPLETED_LORE.asMultiline(NamedTextColor.DARK_PURPLE, this.completedBy.getDisplayName().color(this.completedBy.getTeam().getColor()).decorate(TextDecoration.BOLD).decorate(TextDecoration.ITALIC), ((TextComponent)Component.text(timeString).color(NamedTextColor.GOLD)).decorate(TextDecoration.ITALIC));
            item = new ItemTemplate(completeMaterial, this.getName(), desc);
        } else {
            item = new ItemTemplate(this.icon(displayInfo), this.data.getName(), this.data.getItemDescription());
            item.setAmount(this.data.getRequiredAmount());
        }
        TagDataStorage storage = new TagDataStorage();
        new GameTaskSerializer().toDataStorage((DataStorage)storage, this);
        item.setExtraData(storage);
        if ((this.data.shouldItemGlow() || this.isCompleted()) && !this.isVoided()) {
            item.setGlowing(true);
        }
        item.setMaxStackSize(64);
        return item;
    }

    @Nullable
    public static GameTask fromItem(StackHandle in) {
        TagDataStorage store = in.getStorage();
        return store.toSerializable(GameTask.class);
    }

    public static Key getTaskDataKey(String property) {
        return BingoReloaded.resourceKey("task." + property);
    }

    public boolean complete(BingoParticipant participant, long gameTime) {
        if (this.isCompleted() || this.isVoided()) {
            return false;
        }
        this.completedByTeam = participant.getTeam();
        this.completedBy = participant;
        this.completedAt = gameTime;
        return true;
    }

    public GameTask copy() {
        return new GameTask(this.data);
    }

    public Optional<BingoParticipant> getCompletedByPlayer() {
        return Optional.ofNullable(this.completedBy);
    }

    public Optional<BingoTeam> getCompletedByTeam() {
        return Optional.ofNullable(this.completedByTeam);
    }

    public boolean isCompletedByTeam(@NotNull BingoTeam team) {
        return team.equals(this.completedByTeam);
    }

    public Component getName() {
        if (this.isVoided()) {
            TextComponent.Builder nameBuilder = (TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.DARK_GRAY)).decorate(TextDecoration.STRIKETHROUGH);
            nameBuilder.append(Component.text("A").decorate(TextDecoration.OBFUSCATED));
            nameBuilder.append(this.data.getName().color(NamedTextColor.DARK_GRAY));
            nameBuilder.append(Component.text("A").decorate(TextDecoration.OBFUSCATED));
            return nameBuilder.build();
        }
        if (this.isCompleted()) {
            TextComponent.Builder nameBuilder = (TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).decorate(TextDecoration.STRIKETHROUGH);
            nameBuilder.append(this.data.getName());
            return nameBuilder.build();
        }
        return this.data.getName();
    }

    public ItemType icon(CardDisplayInfo displayInfo) {
        return this.data.getDisplayMaterial(displayInfo);
    }

    public TaskData.TaskType taskType() {
        return this.data.getType();
    }

    public void write(DataOutputStream stream) throws IOException {
        stream.writeBoolean(this.isCompleted());
        if (this.isCompleted()) {
            DataWriter.writeString(this.completedBy.getName(), stream);
            DataWriter.writeString(this.completedByTeam.getIdentifier(), stream);
            stream.writeInt(this.completedByTeam.getColor().value());
        }
        DataWriter.writeString(BingoReloaded.resourceKey(this.taskType().id).asString(), stream);
        stream.writeInt(this.data.getRequiredAmount());
        String key = this.data.getDisplayMaterial(CardDisplayInfo.DUMMY_DISPLAY_INFO).key().asString();
        DataWriter.writeString(key, stream);
    }
}

