/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.tasks;

import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorageSerializer;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameTaskSerializer
implements DataStorageSerializer<GameTask> {
    @Override
    public void toDataStorage(@NotNull DataStorage storage, @NotNull GameTask value) {
        storage.setBoolean("voided", value.isVoided());
        storage.setUUID("completed_by", value.getCompletedByPlayer().isPresent() ? value.getCompletedByPlayer().get().getId() : null);
        storage.setLong("completed_at", value.completedAt);
        storage.setSerializable("task", TaskData.class, value.data);
    }

    @Override
    @Nullable
    public GameTask fromDataStorage(@NotNull DataStorage storage) {
        boolean voided = storage.getBoolean("voided", false);
        UUID completedByUUID = storage.getUUID("completed_by");
        long timeStr = storage.getLong("completed_at", -1L);
        TaskData data = storage.getSerializable("task", TaskData.class);
        GameTask task = new GameTask(data);
        task.setVoided(voided);
        task.completedAt = timeStr;
        return task;
    }
}

