/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.tasks;

import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.data.BingoCardData;
import io.github.steaf23.bingoreloaded.data.TaskListData;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.tasks.data.ItemTask;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class TaskGenerator {
    private static final TaskData DEFAULT_TASK = new ItemTask(ItemType.of("dirt"), 1);

    public static List<GameTask> generateCardTasks(GeneratorSettings settings) {
        BingoCardData cardsData = new BingoCardData();
        TaskListData listsData = cardsData.lists();
        Random shuffler = settings.seed == 0 ? new Random() : new Random(settings.seed);
        HashMap<String, ArrayList<TaskData>> taskMap = new HashMap<String, ArrayList<TaskData>>();
        for (String string : cardsData.getListNames(settings.cardName)) {
            ArrayList<TaskData> arrayList = new ArrayList<TaskData>(listsData.getTasks(string, settings.includeStatistics, settings.includeAdvancements));
            if (arrayList.isEmpty()) continue;
            Collections.shuffle(arrayList, shuffler);
            taskMap.put(string, arrayList);
        }
        List ticketList = new ArrayList<String>();
        for (String string : cardsData.getListsSortedByMin(settings.cardName)) {
            if (!taskMap.containsKey(string)) continue;
            int proportionalMin = Math.max(1, cardsData.getListMin(settings.cardName, string));
            for (int i = 0; i < proportionalMin; ++i) {
                ticketList.add(string);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String listName : cardsData.getListNames(settings.cardName)) {
            byte listMin = cardsData.getListMin(settings.cardName, listName);
            byte listMax = cardsData.getListMax(settings.cardName, listName);
            if (!taskMap.containsKey(listName)) continue;
            int proportionalMin = Math.max(1, listMin);
            byte proportionalMax = listMax;
            for (int i = 0; i < proportionalMax - proportionalMin; ++i) {
                arrayList.add(listName);
            }
        }
        int n = settings.size.fullCardSize;
        Collections.shuffle(arrayList, shuffler);
        ticketList.addAll(arrayList);
        if (ticketList.size() > n) {
            ticketList = ticketList.subList(0, n);
        }
        List<TaskData> newTasks = new ArrayList<TaskData>();
        for (String listName : ticketList) {
            List tasks = (List)taskMap.get(listName);
            if (!tasks.isEmpty()) {
                newTasks.add((TaskData)tasks.removeLast());
                continue;
            }
            ConsoleMessenger.error("Found empty task list '" + listName + "'.");
        }
        while (newTasks.size() < n) {
            newTasks.add(DEFAULT_TASK);
        }
        newTasks = newTasks.subList(0, n);
        Collections.shuffle(newTasks, shuffler);
        return newTasks.stream().map(TaskGenerator::createTaskFromData).toList();
    }

    public static GameTask createTaskFromData(TaskData data) {
        return new GameTask(data);
    }

    public record GeneratorSettings(String cardName, int seed, boolean includeAdvancements, boolean includeStatistics, CardSize size) {
    }
}

