/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.tasks.data;

import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.api.TaskDisplayMode;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.lib.api.AdvancementHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;

public record AdvancementTask(AdvancementHandle advancement) implements TaskData
{
    @Override
    public TaskData.TaskType getType() {
        return TaskData.TaskType.ADVANCEMENT;
    }

    @Override
    public Component getName() {
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("["))).color(NamedTextColor.GREEN)).decorate(TextDecoration.ITALIC);
        if (this.advancement == null) {
            ConsoleMessenger.log("Could not get advancement, returning null!");
            builder.append((Component)Component.text("no advancement?"));
        } else {
            builder.append(ComponentUtils.advancementTitle(this.advancement));
        }
        builder.append((Component)Component.text("]"));
        return builder.build();
    }

    @Override
    public Component[] getItemDescription() {
        return BingoMessage.LORE_ADVANCEMENT.asMultiline(NamedTextColor.DARK_AQUA, new Component[0]);
    }

    @Override
    public Component getChatDescription() {
        return ComponentUtils.advancementDescription(this.advancement).color(NamedTextColor.DARK_AQUA);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvancementTask that = (AdvancementTask)o;
        if (this.advancement == null) {
            return that.advancement == null;
        }
        return this.advancement.key().equals(that.advancement.key());
    }

    @Override
    public int hashCode() {
        return this.advancement.key().hashCode();
    }

    @Override
    public boolean isTaskEqual(TaskData other) {
        return this.equals(other);
    }

    @Override
    public boolean shouldItemGlow() {
        return true;
    }

    @Override
    public ItemType getDisplayMaterial(CardDisplayInfo context) {
        if (context.advancementDisplay() == TaskDisplayMode.GENERIC_TASK_ITEMS || this.advancement().displayIcon() == null) {
            return ItemType.of("filled_map");
        }
        return this.advancement().displayIcon();
    }

    @Override
    public int getRequiredAmount() {
        return 1;
    }

    @Override
    public TaskData setRequiredAmount(int newAmount) {
        return this;
    }
}

