/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.tasks.data;

import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;

public record ItemTask(ItemType itemType, int count) implements TaskData
{
    public ItemTask(ItemType itemType) {
        this(itemType, 1);
    }

    public ItemTask(ItemType itemType, int count) {
        this.itemType = itemType;
        this.count = Math.min(64, Math.max(1, count));
    }

    @Override
    public TaskData.TaskType getType() {
        return TaskData.TaskType.ITEM;
    }

    @Override
    public Component getName() {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.YELLOW)).append((Component)Component.text(this.count + "x "))).append(ComponentUtils.itemName(this.itemType))).build();
    }

    @Override
    public Component[] getItemDescription() {
        return BingoMessage.LORE_ITEM.asMultiline(NamedTextColor.DARK_AQUA, Component.text(this.count));
    }

    @Override
    public Component getChatDescription() {
        return ((TextComponent.Builder)Component.text().append(this.getItemDescription())).build();
    }

    @Override
    public boolean shouldItemGlow() {
        return false;
    }

    @Override
    public ItemType getDisplayMaterial(CardDisplayInfo context) {
        return this.itemType;
    }

    @Override
    public int getRequiredAmount() {
        return this.count;
    }

    @Override
    public TaskData setRequiredAmount(int newAmount) {
        return new ItemTask(this.itemType, newAmount);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemTask itemTask = (ItemTask)o;
        return this.itemType.equals(itemTask.itemType);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.itemType);
    }

    @Override
    public boolean isTaskEqual(TaskData other) {
        if (!(other instanceof ItemTask)) {
            return false;
        }
        ItemTask itemTask = (ItemTask)other;
        return this.itemType.equals(itemTask.itemType);
    }
}

