/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.tasks.data;

import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.api.TaskDisplayMode;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandle;
import io.github.steaf23.bingoreloaded.lib.api.StatisticType;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;

public record StatisticTask(StatisticHandle statistic, int count) implements TaskData
{
    public StatisticTask(StatisticHandle statistic) {
        this(statistic, 1);
    }

    public StatisticTask(StatisticHandle statistic, int count) {
        this.statistic = statistic;
        this.count = Math.min(64, Math.max(1, count));
    }

    @Override
    public TaskData.TaskType getType() {
        return TaskData.TaskType.STATISTIC;
    }

    @Override
    public Component getName() {
        TextComponent amount = Component.text(this.count);
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("*"))).color(NamedTextColor.LIGHT_PURPLE)).decorate(TextDecoration.ITALIC);
        switch (this.statistic.statisticType().getCategory()) {
            case ROOT_STATISTIC: {
                if (this.statistic.statisticType().equals(StatisticType.KILL_ENTITY)) {
                    Component entityName = ComponentUtils.entityName(this.statistic.entityType());
                    Component[] inPlaceArguments = new Component[]{amount, Component.empty()};
                    ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append(ComponentUtils.statistic(this.statistic, inPlaceArguments))).append((Component)Component.text("("))).append(entityName.decorate(TextDecoration.BOLD))).append((Component)Component.text(")"));
                    break;
                }
                if (this.statistic.statisticType().equals(StatisticType.ENTITY_KILLED_BY)) {
                    Component entityName = ComponentUtils.entityName(this.statistic.entityType());
                    Component[] inPlaceArguments = new Component[]{Component.empty(), amount, Component.empty()};
                    ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.text("("))).append(entityName.decorate(TextDecoration.BOLD))).append((Component)Component.text(")"))).append(ComponentUtils.statistic(this.statistic, inPlaceArguments));
                    break;
                }
                ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append(ComponentUtils.statistic(this.statistic, new Component[0]))).append((Component)Component.text(" "))).append(ComponentUtils.itemName(this.statistic.itemType()).decorate(TextDecoration.BOLD))).append((Component)Component.text(": "))).append((Component)amount);
                break;
            }
            case TRAVEL: {
                ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append(ComponentUtils.statistic(this.statistic, new Component[0]))).append((Component)Component.text(": "))).append(Component.text(this.count * 10).decorate(TextDecoration.BOLD))).append((Component)Component.text(" Blocks"));
                break;
            }
            default: {
                ((TextComponent.Builder)((TextComponent.Builder)builder.append(ComponentUtils.statistic(this.statistic, new Component[0]))).append((Component)Component.text(": "))).append((Component)amount);
            }
        }
        builder.append((Component)Component.text("*"));
        return builder.build();
    }

    @Override
    public Component[] getItemDescription() {
        return BingoMessage.LORE_STATISTIC.asMultiline(NamedTextColor.DARK_AQUA, new Component[0]);
    }

    @Override
    public Component getChatDescription() {
        return ((TextComponent.Builder)Component.text().append(this.getItemDescription())).build();
    }

    @Override
    public boolean isTaskEqual(TaskData other) {
        if (!(other instanceof StatisticTask)) {
            return false;
        }
        StatisticTask statisticTask = (StatisticTask)other;
        return this.statistic.equals(statisticTask.statistic);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticTask that = (StatisticTask)o;
        return this.statistic.equals(that.statistic);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.statistic);
    }

    @Override
    public boolean shouldItemGlow() {
        return true;
    }

    @Override
    public ItemType getDisplayMaterial(CardDisplayInfo context) {
        if (context.statisticDisplay() == TaskDisplayMode.GENERIC_TASK_ITEMS) {
            return ItemType.of("globe_banner_pattern");
        }
        return this.statistic().icon();
    }

    @Override
    public int getRequiredAmount() {
        return this.count;
    }

    @Override
    public TaskData setRequiredAmount(int newAmount) {
        return new StatisticTask(this.statistic, newAmount);
    }
}

