/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.tasks.data;

import io.github.steaf23.bingoreloaded.lib.api.AdvancementHandle;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorageSerializer;
import io.github.steaf23.bingoreloaded.tasks.data.AdvancementTask;
import io.github.steaf23.bingoreloaded.tasks.data.ItemTask;
import io.github.steaf23.bingoreloaded.tasks.data.StatisticTask;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TaskStorageSerializer
implements DataStorageSerializer<TaskData> {
    @Override
    public void toDataStorage(@NotNull DataStorage storage, @NotNull TaskData value) {
        TaskData taskData = value;
        Objects.requireNonNull(taskData);
        TaskData taskData2 = taskData;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemTask.class, AdvancementTask.class, StatisticTask.class}, (Object)taskData2, n)) {
            case 0: {
                ItemTask itemTask = (ItemTask)taskData2;
                storage.setNamespacedKey("item", itemTask.itemType().key());
                storage.setInt("count", itemTask.getRequiredAmount());
                break;
            }
            case 1: {
                AdvancementTask advancementTask = (AdvancementTask)taskData2;
                if (advancementTask.advancement() == null) break;
                storage.setNamespacedKey("advancement", advancementTask.advancement().key());
                break;
            }
            case 2: {
                StatisticTask statisticTask = (StatisticTask)taskData2;
                storage.setSerializable("statistic", StatisticHandle.class, statisticTask.statistic());
                storage.setInt("count", statisticTask.getRequiredAmount());
                break;
            }
        }
    }

    @Override
    public TaskData fromDataStorage(@NotNull DataStorage storage) {
        if (storage.contains("item")) {
            return new ItemTask(ItemType.of(storage.getNamespacedKey("item")), storage.getInt("count", 1));
        }
        if (storage.contains("advancement")) {
            return new AdvancementTask(AdvancementHandle.of(storage.getNamespacedKey("advancement")));
        }
        if (storage.contains("statistic")) {
            return new StatisticTask(storage.getSerializable("statistic", StatisticHandle.class), storage.getInt("count", 1));
        }
        throw new IllegalArgumentException("Task type not found while reading game task from file!");
    }
}

