/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.tasks.tracker;

import io.github.steaf23.bingoreloaded.lib.api.StatisticHandle;
import io.github.steaf23.bingoreloaded.lib.api.StatisticType;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import java.util.function.Consumer;

public class StatisticProgress {
    private final StatisticHandle statistic;
    private final BingoParticipant player;
    private int progressLeft;
    private int previousGlobalProgress;
    private final Consumer<StatisticProgress> progressCompletedCallback;

    public StatisticProgress(StatisticHandle statistic, BingoParticipant player, int targetScore, Consumer<StatisticProgress> progressCompletedCallback) {
        this.statistic = statistic;
        this.player = player;
        this.progressLeft = targetScore;
        this.progressCompletedCallback = progressCompletedCallback;
        if (statistic.statisticType().getCategory() == StatisticType.StatisticCategory.TRAVEL) {
            this.progressLeft *= 1000;
        }
        this.previousGlobalProgress = 0;
    }

    public boolean done() {
        return this.progressLeft <= 0;
    }

    public void updatePeriodicProgress() {
        if (this.statistic.getsUpdatedAutomatically()) {
            return;
        }
        int newProgress = this.getParticipantTotalScore();
        this.setProgress(newProgress);
    }

    public void setProgress(int newProgress) {
        int progressDelta = newProgress - this.previousGlobalProgress;
        this.progressLeft -= Math.max(0, progressDelta);
        this.previousGlobalProgress = newProgress;
        if (this.done()) {
            this.progressCompletedCallback.accept(this);
        }
    }

    public int getParticipantTotalScore() {
        PlayerHandle gamePlayer = this.player.sessionPlayer().orElse(null);
        if (gamePlayer == null) {
            return 0;
        }
        int value = this.statistic.hasItemType() ? gamePlayer.getStatisticValue(this.statistic.statisticType(), this.statistic.itemType()) : (this.statistic.hasEntity() ? gamePlayer.getStatisticValue(this.statistic.statisticType(), this.statistic.entityType()) : gamePlayer.getStatisticValue(this.statistic.statisticType()));
        return value;
    }

    public StatisticHandle getStatistic() {
        return this.statistic;
    }

    public int getProgressLeft() {
        return this.progressLeft;
    }

    public BingoParticipant getParticipant() {
        return this.player;
    }
}

