/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.tasks.tracker;

import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.gameloop.phase.BingoGame;
import io.github.steaf23.bingoreloaded.lib.api.AdvancementHandle;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.event.EventResult;
import io.github.steaf23.bingoreloaded.lib.event.EventResults;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.util.DebugLogger;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.tasks.data.AdvancementTask;
import io.github.steaf23.bingoreloaded.tasks.data.ItemTask;
import io.github.steaf23.bingoreloaded.tasks.data.StatisticTask;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import io.github.steaf23.bingoreloaded.tasks.tracker.StatisticProgress;
import io.github.steaf23.bingoreloaded.tasks.tracker.StatisticTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskProgressTracker {
    private final ServerSoftware platform;
    private final BingoGame game;
    private final Map<GameTask, List<TaskProgress>> progressMap;
    private final StatisticTracker statisticTracker;
    private boolean updateClient;

    public TaskProgressTracker(ServerSoftware platform, @NotNull BingoGame game) {
        this.platform = platform;
        this.game = game;
        this.progressMap = new HashMap<GameTask, List<TaskProgress>>();
        this.statisticTracker = new StatisticTracker();
        this.updateClient = true;
    }

    public void setUpdateClient(boolean update) {
        this.updateClient = update;
    }

    public boolean shouldUpdateClient() {
        return this.updateClient;
    }

    public void startTrackingTask(GameTask task) {
        this.progressMap.put(task, new ArrayList());
        for (BingoParticipant participant : this.game.getTeamManager().getParticipants()) {
            Optional<TaskCard> card = participant.getCard();
            if (card.isEmpty() || !card.get().getTasks().contains(task)) continue;
            int finalCount = task.data.getRequiredAmount();
            TaskData.TaskType type = task.data.getType();
            if (type == TaskData.TaskType.ADVANCEMENT) {
                AdvancementTask advancementTask = (AdvancementTask)task.data;
                participant.sessionPlayer().ifPresent(player -> {
                    player.removeAdvancementProgress(advancementTask.advancement());
                    DebugLogger.addLog("Revoking advancement " + advancementTask.advancement().key().value() + " for player " + player.playerName());
                });
            } else if (type == TaskData.TaskType.STATISTIC) {
                StatisticTask statisticTask = (StatisticTask)task.data;
                this.statisticTracker.addStatistic(statisticTask, participant, this::onBingoStatisticCompleted);
            }
            this.progressMap.get(task).add(new TaskProgress(participant, finalCount));
            PlayerHandle player2 = participant.sessionPlayer().orElse(null);
            if (player2 == null || !this.updateClient) continue;
            this.game.getSession().getGameManager().getRuntime().getClientManager().updateCard(player2, card.get());
        }
    }

    public void handlePlayerAdvancementDone(PlayerHandle player, AdvancementHandle advancement) {
        BingoParticipant participant = this.getValidParticipant(player);
        if (participant == null) {
            return;
        }
        if (this.game.getDeathMatchTask() != null) {
            return;
        }
        if (!advancement.key().value().startsWith("recipes")) {
            DebugLogger.addLog("Advancement " + advancement.key().value() + " completed by " + player.playerName());
        }
        this.updateProgressFromEvent(participant, (task, progress) -> {
            if (task.taskType() != TaskData.TaskType.ADVANCEMENT) {
                return false;
            }
            AdvancementTask data = (AdvancementTask)task.data;
            if (!data.advancement().key().equals(advancement.key())) {
                return false;
            }
            progress.addProgress(1);
            DebugLogger.addLog("Completed task " + advancement.key().value() + " completed by player " + participant.getName());
            return this.tryCompleteTask((GameTask)task, (TaskProgress)progress);
        });
    }

    public void onBingoStatisticCompleted(StatisticProgress completedStat) {
        BingoParticipant participant = this.getValidParticipant(completedStat.getParticipant());
        if (participant == null) {
            return;
        }
        if (this.game.getDeathMatchTask() != null) {
            return;
        }
        this.updateProgressFromEvent(participant, (task, progress) -> {
            if (task.taskType() != TaskData.TaskType.STATISTIC) {
                return false;
            }
            StatisticHandle statistic = completedStat.getStatistic();
            StatisticTask data = (StatisticTask)task.data;
            if (!data.statistic().equals(statistic)) {
                return false;
            }
            progress.setProgress(data.getRequiredAmount());
            return this.tryCompleteTask((GameTask)task, (TaskProgress)progress);
        });
    }

    public void handlePlayerStatIncrement(PlayerHandle player, StatisticHandle statistic, int newValue) {
        BingoParticipant participant = this.game.getTeamManager().getPlayerAsParticipant(player);
        if (participant == null || participant.sessionPlayer().isEmpty()) {
            return;
        }
        this.statisticTracker.handleStatisticIncrement(participant, statistic, newValue, this.game);
    }

    private StackHandle completeItemSlot(StackHandle item, BingoParticipant participant) {
        if (participant == null || participant.getTeam() == null) {
            return item;
        }
        if (participant.getTeam().outOfTheGame) {
            return item;
        }
        GameTask deathMatchTask = this.game.getDeathMatchTask();
        if (deathMatchTask != null) {
            TaskData taskData = deathMatchTask.data;
            if (taskData instanceof ItemTask) {
                ItemTask task2 = (ItemTask)taskData;
                if (item.type().equals(task2.itemType())) {
                    deathMatchTask.complete(participant, this.game.getGameTime());
                    this.game.onDeathmatchTaskComplete(participant, deathMatchTask);
                }
            } else {
                ConsoleMessenger.bug("Did not expect a non-item task for a deathmatch task, cannot complete the game!", (Object)this);
            }
            return item;
        }
        this.updateProgressFromEvent(participant, (task, progress) -> {
            if (task.taskType() != TaskData.TaskType.ITEM) {
                return false;
            }
            ItemTask data = (ItemTask)task.data;
            if (!data.itemType().equals(item.type()) || data.count() > item.amount()) {
                return false;
            }
            progress.setProgress(item.amount());
            if (!this.tryCompleteTask((GameTask)task, (TaskProgress)progress)) {
                return false;
            }
            participant.sessionPlayer().ifPresent(player -> {
                if (this.game.getConfig().getOptionValue(BingoOptions.REMOVE_TASK_ITEMS).booleanValue()) {
                    item.setAmount(item.amount() - data.getRequiredAmount());
                }
            });
            return true;
        });
        return item;
    }

    public void handleInventoryClicked(PlayerHandle player, StackHandle itemOnCursor, boolean resultSlot, boolean shiftClicked) {
        BingoParticipant participant = this.getValidParticipant(player);
        if (participant == null) {
            return;
        }
        if (resultSlot && !shiftClicked) {
            this.platform.runTask(task -> this.completeItemSlot(itemOnCursor, participant));
            return;
        }
        this.platform.runTask(task -> {
            for (StackHandle stack : player.inventory().contents()) {
                if (stack == null) continue;
                this.completeItemSlot(stack, participant);
            }
            this.completeItemSlot(itemOnCursor, participant);
        });
    }

    public EventResult<EventResults.PlayerPickupResult> handlePlayerPickupItem(PlayerHandle player, StackHandle stack, WorldPosition itemLocation) {
        BingoParticipant participant = this.getValidParticipant(player);
        if (participant == null) {
            return new EventResult<Object>(false, null);
        }
        int amount = stack.amount();
        stack = this.completeItemSlot(stack, participant);
        boolean cancel = false;
        boolean removeItem = false;
        if (amount != stack.amount()) {
            cancel = true;
            StackHandle resultStack = stack.clone();
            if (resultStack.type().isAir() || resultStack.amount() <= 0) {
                return EventResults.playerPickupResult(true, false, true, stack);
            }
            removeItem = true;
            this.platform.runTask(task -> participant.sessionPlayer().ifPresent(p -> p.world().dropItem(resultStack, itemLocation)));
        }
        return EventResults.playerPickupResult(cancel, removeItem, false, null);
    }

    public void handlePlayerDroppedItem(PlayerHandle player, StackHandle stack) {
        BingoParticipant participant = this.getValidParticipant(player);
        if (participant == null) {
            return;
        }
        StackWrapped wrapped = new StackWrapped(stack);
        this.platform.runTask(task -> {
            StackHandle internal = wrapped.stack();
            internal = this.completeItemSlot(stack, participant);
        });
    }

    public void updateStatisticProgress() {
        this.statisticTracker.updateProgress();
    }

    public void removeTask(GameTask task) {
        this.progressMap.remove(task);
        if (task.taskType() == TaskData.TaskType.STATISTIC) {
            this.statisticTracker.removeStatistic((StatisticTask)task.data);
        }
    }

    private boolean tryCompleteTask(GameTask task, TaskProgress progress) {
        if (!progress.isDone()) {
            return false;
        }
        BingoParticipant player = progress.participant;
        if (player == null) {
            return false;
        }
        if (!(player.getSession().getPhase() instanceof BingoGame)) {
            return false;
        }
        if (!task.complete(player, this.game.getGameTime())) {
            return false;
        }
        if (player.getTeam() == null) {
            ConsoleMessenger.bug("Player " + player.getName() + " is not in a valid team!", (Object)this);
        }
        player.getCard().ifPresent(card -> card.onTaskCompleted(player, task, this.game.getGameTime()));
        this.game.onBingoTaskCompleted(player, task);
        return true;
    }

    @Nullable
    private BingoParticipant getValidParticipant(@Nullable BingoParticipant participant) {
        return this.getValidParticipant(participant != null ? (PlayerHandle)participant.sessionPlayer().orElse(null) : null);
    }

    @Nullable
    private BingoParticipant getValidParticipant(@Nullable PlayerHandle player) {
        if (player == null) {
            return null;
        }
        if (!this.game.getSession().hasPlayer(player)) {
            return null;
        }
        BingoParticipant participant = this.game.getTeamManager().getPlayerAsParticipant(player);
        if (participant == null || participant.getTeam() == null || participant.getTeam().outOfTheGame) {
            return null;
        }
        return participant;
    }

    private void updateProgressFromEvent(BingoParticipant participant, BiFunction<GameTask, TaskProgress, Boolean> updateFunction) {
        HashSet<GameTask> tasksToRemove = new HashSet<GameTask>();
        for (GameTask task : this.progressMap.keySet()) {
            for (TaskProgress progress : this.progressMap.get(task)) {
                if (!progress.participant.equals(participant) || !updateFunction.apply(task, progress).booleanValue()) continue;
                tasksToRemove.add(task);
            }
        }
        tasksToRemove.forEach(this.progressMap::remove);
    }

    public static class TaskProgress {
        private final BingoParticipant participant;
        private final int progressStart;
        private int progressLeft;

        public TaskProgress(BingoParticipant participant, int progressAmount) {
            this.participant = participant;
            this.progressLeft = this.progressStart = progressAmount;
        }

        public boolean isDone() {
            return this.progressLeft == 0;
        }

        public void addProgress(int amount) {
            this.progressLeft = Math.max(0, this.progressLeft - amount);
        }

        public void setProgress(int amount) {
            this.progressLeft = Math.max(0, this.progressStart - amount);
        }
    }

    private record StackWrapped(StackHandle stack) {
    }
}

