/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.util;

import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;

public class ActionBarManager {
    private final BingoSession session;
    private int tickCounter;
    private final PriorityQueue<ActionBarMessage> messages;

    public ActionBarManager(BingoSession session) {
        this.session = session;
        this.messages = new PriorityQueue<ActionBarMessage>(Comparator.comparingInt(b -> -b.priority));
    }

    public void requestMessage(Function<Audience, Component> messageTemplate, int priority) {
        this.requestMessage(messageTemplate, priority, 0);
    }

    public void requestMessage(Function<Audience, Component> messageTemplate, int priority, int lingerTime) {
        this.messages.add(new ActionBarMessage(messageTemplate, priority, lingerTime, this.tickCounter));
    }

    public void update() {
        ActionBarMessage topMessage = this.messages.peek();
        if (topMessage == null) {
            return;
        }
        if (topMessage.insertionTime + topMessage.lingerTime <= this.tickCounter) {
            this.messages.poll();
        }
        ActionBarMessage messageToShow = topMessage;
        this.session.teamManager.getParticipants().forEach(p -> p.sessionPlayer().ifPresent(player -> player.sendActionBar(messageToShow.messageTemplate.apply((Audience)player))));
        while (topMessage != null && topMessage.insertionTime + topMessage.lingerTime <= this.tickCounter) {
            this.messages.poll();
            topMessage = this.messages.peek();
        }
        ++this.tickCounter;
    }

    private record ActionBarMessage(Function<Audience, Component> messageTemplate, int priority, int lingerTime, int insertionTime) {
    }
}

