/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.util.timer;

import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.util.timer.GameTimer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.Nullable;

public class CountdownTimer
extends GameTimer {
    private final int startTime;
    public final int medThreshold;
    public final int lowThreshold;
    private final Runnable onTimeoutCallback;

    public CountdownTimer(int seconds, @Nullable Runnable onTimeoutCallback) {
        this(seconds, 0, 0, onTimeoutCallback);
    }

    public CountdownTimer(int seconds, int medThreshold, int lowThreshold, @Nullable Runnable onTimeoutCallback) {
        this.medThreshold = medThreshold;
        this.lowThreshold = lowThreshold;
        this.startTime = seconds;
        this.onTimeoutCallback = onTimeoutCallback;
    }

    public int getStartTime() {
        return this.startTime;
    }

    @Override
    public void start() {
        this.updateTime(this.startTime);
        if (this.startTime == 0) {
            this.stop();
            return;
        }
        super.start();
    }

    @Override
    protected void updateTime(long newTime) {
        super.updateTime(newTime);
        if (this.getTime() <= 0L) {
            if (this.onTimeoutCallback != null) {
                this.onTimeoutCallback.run();
            }
            this.stop();
        }
    }

    @Override
    public Component getTimeDisplayMessage(boolean asSeconds) {
        String timeString = asSeconds ? GameTimer.getSecondsString(this.getTime()) : GameTimer.getTimeAsString(this.getTime());
        NamedTextColor color = NamedTextColor.WHITE;
        if (this.getTime() <= (long)this.lowThreshold) {
            color = NamedTextColor.RED;
        } else if (this.getTime() <= (long)this.medThreshold) {
            color = NamedTextColor.GOLD;
        }
        return BingoMessage.TIME_LEFT.asPhrase(Component.text(timeString).color(color)).color(NamedTextColor.LIGHT_PURPLE).decorate(TextDecoration.BOLD);
    }

    @Override
    public int getStartDelay() {
        return 0;
    }

    @Override
    public int getUpdateInterval() {
        return 20;
    }

    @Override
    public int getStep() {
        return -1;
    }
}

