/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.util.timer;

import io.github.steaf23.bingoreloaded.lib.api.ExtensionTask;
import io.github.steaf23.bingoreloaded.lib.api.PlatformResolver;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public abstract class GameTimer {
    private final List<Consumer<Long>> notifiers = new ArrayList<Consumer<Long>>();
    private long time = 0L;
    private ExtensionTask task = null;

    public abstract Component getTimeDisplayMessage(boolean var1);

    public abstract int getStartDelay();

    public abstract int getUpdateInterval();

    public abstract int getStep();

    public void start() {
        this.stop();
        this.task = PlatformResolver.get().runTaskTimer(this.getUpdateInterval(), this.getStartDelay(), task -> this.updateTime(this.time + (long)this.getStep()));
    }

    public long pause() {
        return this.getTime();
    }

    public long stop() {
        try {
            if (this.task != null) {
                this.task.cancel();
            }
        }
        catch (IllegalStateException e) {
            ConsoleMessenger.bug("A Timer couldn't be stopped since it never started!", (Object)this);
            return -1L;
        }
        this.task = null;
        return this.getTime();
    }

    public long getTime() {
        return this.time;
    }

    protected void updateTime(long newTime) {
        this.time = newTime;
        for (Consumer<Long> notifier : this.notifiers) {
            notifier.accept(newTime);
        }
    }

    public static String getTimeAsString(long seconds) {
        if ((seconds = Math.max(seconds, 0L)) >= 60L) {
            long minutes = seconds / 60L % 60L;
            if (seconds >= 3600L) {
                long hours = seconds / 3600L;
                return String.format("%02d:%02d:%02d", hours, minutes, seconds % 60L);
            }
            return String.format("%02d:%02d", minutes, seconds % 60L);
        }
        return String.format("00:%02d", seconds % 60L);
    }

    public static Component getTimeAsComponent(long seconds) {
        return Component.text(GameTimer.getTimeAsString(seconds));
    }

    public static String getSecondsString(long seconds) {
        return String.format("%d", seconds);
    }

    public void addNotifier(@NotNull Consumer<Long> notifier) {
        this.notifiers.add(notifier);
    }

    public boolean isRunning() {
        return this.task != null && !this.task.isCancelled();
    }
}

