/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.util.DebugLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.event.Event;
import org.bukkit.event.world.WorldLoadEvent;
import org.jetbrains.annotations.Nullable;

public class CustomWorldCreator_V1_21_4 {
    public static World createBingoWorld(String worldName, @Nullable Key noiseSettingsLocation) {
        LevelStem customStem;
        PrimaryLevelData primaryLevelData;
        Dynamic dataTag;
        LevelStorageSource.LevelStorageAccess levelStorageAccess;
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        DedicatedServer console = craftServer.getServer();
        Preconditions.checkState((boolean)console.getAllLevels().iterator().hasNext(), (Object)"Cannot create additional worlds on STARTUP");
        File folder = new File(Bukkit.getWorldContainer(), worldName);
        World world = Bukkit.getWorld((String)worldName);
        if (world != null) {
            return world;
        }
        if (folder.exists()) {
            Preconditions.checkArgument((boolean)folder.isDirectory(), (String)"File (%s) exists and isn't a folder", (Object)worldName);
        }
        ResourceKey actualDimension = LevelStem.OVERWORLD;
        try {
            levelStorageAccess = LevelStorageSource.createDefault((Path)Bukkit.getWorldContainer().toPath()).validateAndCreateAccess(worldName, actualDimension);
        }
        catch (IOException | ContentValidationException ex) {
            throw new RuntimeException(ex);
        }
        if (levelStorageAccess.hasWorldData()) {
            LevelSummary summary;
            try {
                dataTag = levelStorageAccess.getDataTag();
                summary = levelStorageAccess.getSummary(dataTag);
            }
            catch (IOException | NbtException | ReportedNbtException e) {
                LevelStorageSource.LevelDirectory levelDirectory = levelStorageAccess.getLevelDirectory();
                MinecraftServer.LOGGER.warn("Failed to load world data from {}", (Object)levelDirectory.dataFile(), (Object)e);
                MinecraftServer.LOGGER.info("Attempting to use fallback");
                try {
                    dataTag = levelStorageAccess.getDataTagFallback();
                    summary = levelStorageAccess.getSummary(dataTag);
                }
                catch (IOException | NbtException | ReportedNbtException e1) {
                    MinecraftServer.LOGGER.error("Failed to load world data from {}", (Object)levelDirectory.oldDataFile(), (Object)e1);
                    MinecraftServer.LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)levelDirectory.dataFile(), (Object)levelDirectory.oldDataFile());
                    return null;
                }
                levelStorageAccess.restoreLevelDataFromOld();
            }
            if (summary.requiresManualConversion()) {
                MinecraftServer.LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                return null;
            }
            if (!summary.isCompatible()) {
                MinecraftServer.LOGGER.info("This world was created by an incompatible version.");
                return null;
            }
        } else {
            dataTag = null;
        }
        WorldLoader.DataLoadContext context = console.worldLoader;
        RegistryAccess.Frozen registryAccess = context.datapackDimensions();
        Registry contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        if (dataTag != null) {
            LevelDataAndDimensions levelDataAndDimensions = LevelStorageSource.getLevelDataAndDimensions((Dynamic)dataTag, (WorldDataConfiguration)context.dataConfiguration(), (Registry)contextLevelStemRegistry, (HolderLookup.Provider)context.datapackWorldgen());
            primaryLevelData = (PrimaryLevelData)levelDataAndDimensions.worldData();
            registryAccess = levelDataAndDimensions.dimensions().dimensionsRegistryAccess();
        } else {
            WorldOptions worldOptions = new WorldOptions(new Random().nextLong(), true, false);
            DedicatedServerProperties.WorldDimensionData properties = new DedicatedServerProperties.WorldDimensionData(GsonHelper.parse((String)"{}"), WorldType.NORMAL.name().toLowerCase(Locale.ROOT));
            LevelSettings levelSettings = new LevelSettings(worldName, GameType.byId((int)Bukkit.getDefaultGameMode().getValue()), false, Difficulty.EASY, false, new GameRules(context.dataConfiguration().enabledFeatures()), context.dataConfiguration());
            WorldDimensions worldDimensions = properties.create(context.datapackWorldgen());
            WorldDimensions.Complete complete = worldDimensions.bake(contextLevelStemRegistry);
            Lifecycle lifecycle = complete.lifecycle().add(context.datapackWorldgen().allRegistriesLifecycle());
            primaryLevelData = new PrimaryLevelData(levelSettings, worldOptions, complete.specialWorldProperty(), lifecycle);
            registryAccess = complete.dimensionsRegistryAccess();
        }
        contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        LevelStem existingStem = (LevelStem)contextLevelStemRegistry.getValue(actualDimension);
        if (noiseSettingsLocation == null) {
            DebugLogger.addLog("Noise generation settings location null (invalid namespaced key");
            customStem = existingStem;
        } else if (existingStem == null) {
            DebugLogger.addLog("No existing level stem found for overworld dimension? (big oopsie)");
            customStem = null;
        } else {
            ResourceKey noiseSettingsKey = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)noiseSettingsLocation.namespace(), (String)noiseSettingsLocation.value()));
            Registry settingsRegistry = console.registryAccess().lookupOrThrow(Registries.NOISE_SETTINGS);
            Optional bingoNoiseSettings = settingsRegistry.get(noiseSettingsKey);
            if (bingoNoiseSettings.isPresent()) {
                NoiseBasedChunkGenerator chunkGen = new NoiseBasedChunkGenerator(existingStem.generator().getBiomeSource(), (Holder)bingoNoiseSettings.get());
                customStem = new LevelStem(existingStem.type(), (ChunkGenerator)chunkGen);
            } else {
                ConsoleMessenger.error("Noise generation settings called " + String.valueOf(noiseSettingsLocation) + " could not be found in enabled datapacks, please double check all your installed datapacks and verify that the generation settings are present.");
                ConsoleMessenger.log("To prevent this message from showing you can also set the config option customWorldGeneration to 'null' to use vanilla generation instead");
                customStem = existingStem;
            }
        }
        primaryLevelData.customDimensions = contextLevelStemRegistry;
        primaryLevelData.checkName(worldName);
        primaryLevelData.setModdedInfo(console.getServerModName(), console.getModdedStatus().shouldReportAsModified());
        long i = BiomeManager.obfuscateSeed((long)primaryLevelData.worldGenOptions().seed());
        ImmutableList additionalSpawners = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner((ServerLevelData)primaryLevelData));
        String levelName = console.getProperties().levelName;
        ResourceKey dimensionKey = worldName.equals(levelName + "_nether") ? Level.NETHER : (worldName.equals(levelName + "_the_end") ? Level.END : ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)worldName.toLowerCase(Locale.ROOT))));
        ((GameRules.IntegerValue)primaryLevelData.getGameRules().getRule(GameRules.RULE_SPAWN_CHUNK_RADIUS)).set(0, null);
        ServerLevel serverLevel = new ServerLevel((MinecraftServer)console, console.executor, levelStorageAccess, primaryLevelData, dimensionKey, customStem, console.progressListenerFactory.create(primaryLevelData.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS)), primaryLevelData.isDebugWorld(), i, (List)additionalSpawners, true, console.overworld().getRandomSequences(), World.Environment.NORMAL, null, null);
        if (craftServer.getWorld(worldName) == null) {
            return null;
        }
        console.addLevel(serverLevel);
        console.initWorld(serverLevel, (ServerLevelData)primaryLevelData, (WorldData)primaryLevelData, primaryLevelData.worldGenOptions());
        serverLevel.setSpawnSettings(true);
        console.prepareLevels(serverLevel.getChunkSource().chunkMap.progressListener, serverLevel);
        Bukkit.getPluginManager().callEvent((Event)new WorldLoadEvent((World)serverLevel.getWorld()));
        return serverLevel.getWorld();
    }
}

