/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import simplexity.simplepms.commands.Block;
import simplexity.simplepms.commands.Blocklist;
import simplexity.simplepms.commands.MessageToggle;
import simplexity.simplepms.commands.PrivateMessage;
import simplexity.simplepms.commands.Reload;
import simplexity.simplepms.commands.Reply;
import simplexity.simplepms.commands.SocialSpy;
import simplexity.simplepms.commands.Unblock;
import simplexity.simplepms.config.ConfigHandler;
import simplexity.simplepms.listeners.JoinListener;
import simplexity.simplepms.listeners.PreCommandListener;
import simplexity.simplepms.listeners.QuitListener;
import simplexity.simplepms.logic.Constants;
import simplexity.simplepms.saving.SqlHandler;

public final class SimplePMs
extends JavaPlugin {
    private static Plugin instance;
    private static final MiniMessage miniMessage;
    private static boolean papiEnabled;
    private static ConsoleCommandSender consoleSender;

    public void onEnable() {
        instance = this;
        consoleSender = this.getServer().getConsoleSender();
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            papiEnabled = true;
        }
        this.loadConfigStuff();
        SqlHandler.getInstance().init();
        this.registerListeners();
        this.registerCommands();
        this.registerPermissions();
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new QuitListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PreCommandListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(), (Plugin)this);
    }

    private void loadConfigStuff() {
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        ConfigHandler.getInstance().loadConfigValues();
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> {
            ((Commands)commands.registrar()).register(PrivateMessage.createCommand());
            ((Commands)commands.registrar()).register(PrivateMessage.createTellAlias());
            ((Commands)commands.registrar()).register(PrivateMessage.createWhisperAlias());
            ((Commands)commands.registrar()).register(Reply.createCommand());
            ((Commands)commands.registrar()).register(Reply.createAlias());
            ((Commands)commands.registrar()).register(Block.createCommand());
            ((Commands)commands.registrar()).register(Unblock.createCommand());
            ((Commands)commands.registrar()).register(MessageToggle.createCommand());
            ((Commands)commands.registrar()).register(SocialSpy.createCommand());
            ((Commands)commands.registrar()).register(SocialSpy.createAlias());
            ((Commands)commands.registrar()).register(Reload.createCommand());
            ((Commands)commands.registrar()).register(Blocklist.createCommand());
        });
    }

    private void registerPermissions() {
        this.getServer().getPluginManager().addPermission(Constants.MESSAGE_BASIC);
        this.getServer().getPluginManager().addPermission(Constants.MESSAGE_ADMIN);
        this.getServer().getPluginManager().addPermission(Constants.MESSAGE_SEND);
        this.getServer().getPluginManager().addPermission(Constants.MESSAGE_RECEIVE);
        this.getServer().getPluginManager().addPermission(Constants.MESSAGE_TOGGLE);
        this.getServer().getPluginManager().addPermission(Constants.MESSAGE_BLOCK);
        this.getServer().getPluginManager().addPermission(Constants.PLUGIN_RELOAD);
        this.getServer().getPluginManager().addPermission(Constants.ADMIN_OVERRIDE);
        this.getServer().getPluginManager().addPermission(Constants.ADMIN_SOCIAL_SPY);
        this.getServer().getPluginManager().addPermission(Constants.ADMIN_CONSOLE_SPY);
        this.getServer().getPluginManager().addPermission(Constants.BYPASS_SOCIAL_SPY);
        this.getServer().getPluginManager().addPermission(Constants.BYPASS_COMMAND_SPY);
    }

    public void onDisable() {
        SqlHandler.getInstance().shutdownConnection();
    }

    public static MiniMessage getMiniMessage() {
        return miniMessage;
    }

    public static Plugin getInstance() {
        return instance;
    }

    public static boolean isPapiEnabled() {
        return papiEnabled;
    }

    public static ConsoleCommandSender getPMConsoleSender() {
        return consoleSender;
    }

    static {
        miniMessage = MiniMessage.miniMessage();
        papiEnabled = false;
    }
}

