/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import simplexity.simplepms.commands.arguments.OfflinePlayerArgument;
import simplexity.simplepms.commands.util.Exceptions;
import simplexity.simplepms.config.LocaleMessage;
import simplexity.simplepms.logic.BlockHandler;
import simplexity.simplepms.logic.Constants;

public class Block {
    public static LiteralCommandNode<CommandSourceStack> createCommand() {
        OfflinePlayerArgument offlinePlayerArg = new OfflinePlayerArgument();
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"block").requires(Block::canExecute)).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)offlinePlayerArg).suggests(offlinePlayerArg::suggestOnlinePlayers).executes(Block::execute)).then(Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(Block::executeWithReason)))).build();
    }

    private static boolean canExecute(CommandSourceStack css) {
        if (!(css.getSender() instanceof Player)) {
            return false;
        }
        return css.getSender().hasPermission(Constants.MESSAGE_BLOCK);
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            throw Exceptions.ERROR_MUST_BE_PLAYER.create();
        }
        Player playerSender = (Player)sender;
        OfflinePlayer target = (OfflinePlayer)ctx.getArgument("target", OfflinePlayer.class);
        BlockHandler.addBlockedPlayer(playerSender, target, null);
        Block.sendSuccessMessage(playerSender, target);
        return 1;
    }

    private static int executeWithReason(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            throw Exceptions.ERROR_MUST_BE_PLAYER.create();
        }
        Player playerSender = (Player)sender;
        OfflinePlayer target = (OfflinePlayer)ctx.getArgument("target", OfflinePlayer.class);
        String reason = (String)ctx.getArgument("reason", String.class);
        BlockHandler.addBlockedPlayer(playerSender, target, reason);
        Block.sendSuccessMessage(playerSender, target);
        return 1;
    }

    private static void sendSuccessMessage(@NotNull Player sender, @NotNull OfflinePlayer blockedPlayer) {
        String blockedPlayerName = blockedPlayer.getName();
        if (blockedPlayerName == null) {
            blockedPlayerName = "[NO NAME FOUND]";
        }
        sender.sendRichMessage(LocaleMessage.BLOCKED_PLAYER.getMessage(), new TagResolver[]{Placeholder.parsed((String)"name", (String)blockedPlayerName)});
    }
}

