/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import simplexity.simplepms.SimplePMs;
import simplexity.simplepms.config.LocaleMessage;
import simplexity.simplepms.logic.Constants;
import simplexity.simplepms.saving.Cache;
import simplexity.simplepms.saving.objects.PlayerBlock;

public class Blocklist {
    private static final MiniMessage miniMessage = SimplePMs.getMiniMessage();

    public static LiteralCommandNode<CommandSourceStack> createCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blocklist").requires(Blocklist::canExecute)).executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
            UUID uuid = player.getUniqueId();
            List<PlayerBlock> blockList = Cache.getBlockList(uuid);
            if (blockList == null || blockList.isEmpty()) {
                player.sendRichMessage(LocaleMessage.BLOCKLIST_EMPTY.getMessage());
                return 1;
            }
            Component message = miniMessage.deserialize((Object)LocaleMessage.BLOCKLIST_HEADER.getMessage());
            for (PlayerBlock block : blockList) {
                message = message.appendNewline();
                message = message.append(miniMessage.deserialize(LocaleMessage.BLOCKLIST_NAME.getMessage(), (TagResolver)Placeholder.parsed((String)"name", (String)block.getBlockedPlayerName())));
                if (block.getBlockReason() == null || block.getBlockReason().isEmpty()) continue;
                message = message.append(miniMessage.deserialize(LocaleMessage.BLOCKLIST_REASON.getMessage(), (TagResolver)Placeholder.parsed((String)"reason", (String)block.getBlockReason())));
            }
            player.sendMessage(message);
            return 1;
        })).build();
    }

    private static boolean canExecute(CommandSourceStack css) {
        if (!(css.getSender() instanceof Player)) {
            return false;
        }
        return css.getSender().hasPermission(Constants.MESSAGE_BLOCK);
    }
}

