/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.UUID;
import org.bukkit.entity.Player;
import simplexity.simplepms.config.LocaleMessage;
import simplexity.simplepms.logic.Constants;
import simplexity.simplepms.saving.Cache;
import simplexity.simplepms.saving.objects.PlayerSettings;

public class MessageToggle {
    public static LiteralCommandNode<CommandSourceStack> createCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"msgtoggle").requires(MessageToggle::canExecute)).executes(ctx -> {
            Player sender = (Player)((CommandSourceStack)ctx.getSource()).getSender();
            UUID playerUuid = sender.getUniqueId();
            PlayerSettings playerSettings = Cache.getPlayerSettings(playerUuid);
            if (playerSettings.areMessagesDisabled()) {
                Cache.updateMessageSettings(playerUuid, false);
                sender.sendRichMessage(LocaleMessage.MESSAGES_ENABLED.getMessage());
                return 1;
            }
            Cache.updateMessageSettings(playerUuid, true);
            sender.sendRichMessage(LocaleMessage.MESSAGES_DISABLED.getMessage());
            return 1;
        })).build();
    }

    public static boolean canExecute(CommandSourceStack css) {
        if (!(css.getSender() instanceof Player)) {
            return false;
        }
        return css.getSender().hasPermission(Constants.MESSAGE_TOGGLE);
    }
}

