/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import org.bukkit.command.CommandSender;
import simplexity.simplepms.commands.arguments.Target;
import simplexity.simplepms.commands.arguments.TargetArgument;
import simplexity.simplepms.commands.util.MessageChecks;
import simplexity.simplepms.logic.Constants;
import simplexity.simplepms.logic.PMHandler;

public class PrivateMessage {
    public static LiteralCommandNode<CommandSourceStack> createCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"msg").requires(PrivateMessage::canExecute)).then(PrivateMessage.targetArg().then(PrivateMessage.messageArg()))).build();
    }

    public static LiteralCommandNode<CommandSourceStack> createTellAlias() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tell").requires(PrivateMessage::canExecute)).then(PrivateMessage.targetArg().then(PrivateMessage.messageArg()))).build();
    }

    public static LiteralCommandNode<CommandSourceStack> createWhisperAlias() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"w").requires(PrivateMessage::canExecute)).then(PrivateMessage.targetArg().then(PrivateMessage.messageArg()))).build();
    }

    private static RequiredArgumentBuilder<CommandSourceStack, Target> targetArg() {
        TargetArgument targetArg = new TargetArgument();
        return Commands.argument((String)"target", (ArgumentType)targetArg).suggests(targetArg::suggestOnlinePlayers);
    }

    private static RequiredArgumentBuilder<CommandSourceStack, String> messageArg() {
        return (RequiredArgumentBuilder)Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(PrivateMessage::execute);
    }

    private static boolean canExecute(CommandSourceStack css) {
        return css.getSender().hasPermission(Constants.MESSAGE_SEND);
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        Target argTarget = (Target)ctx.getArgument("target", Target.class);
        CommandSender target = argTarget.sender();
        MessageChecks.userChecks(sender, target, argTarget.providedName());
        String message = (String)ctx.getArgument("message", String.class);
        PMHandler.handlePrivateMessage(sender, target, message);
        return 1;
    }
}

