/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import org.bukkit.command.CommandSender;
import simplexity.simplepms.commands.util.Exceptions;
import simplexity.simplepms.commands.util.MessageChecks;
import simplexity.simplepms.logic.Constants;
import simplexity.simplepms.logic.PMHandler;

public class Reply {
    public static LiteralCommandNode<CommandSourceStack> createCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reply").requires(Reply::canExecute)).then(Reply.messageArg())).build();
    }

    public static LiteralCommandNode<CommandSourceStack> createAlias() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"r").requires(Reply::canExecute)).then(Reply.messageArg())).build();
    }

    private static boolean canExecute(CommandSourceStack css) {
        return css.getSender().hasPermission(Constants.MESSAGE_SEND);
    }

    private static RequiredArgumentBuilder<CommandSourceStack, String> messageArg() {
        return (RequiredArgumentBuilder)Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(Reply::execute);
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        CommandSender target = PMHandler.lastMessaged.get(sender);
        if (target == null) {
            throw Exceptions.ERROR_NOBODY_TO_REPLY_TO.create();
        }
        MessageChecks.userChecks(sender, target, target.getName());
        String message = (String)ctx.getArgument("message", String.class);
        PMHandler.handlePrivateMessage(sender, target, message);
        return 1;
    }
}

