/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import simplexity.simplepms.commands.util.Exceptions;
import simplexity.simplepms.config.LocaleMessage;
import simplexity.simplepms.logic.Constants;
import simplexity.simplepms.logic.UnblockHandler;
import simplexity.simplepms.saving.Cache;
import simplexity.simplepms.saving.objects.PlayerBlock;

public class Unblock {
    public static LiteralCommandNode<CommandSourceStack> createCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unblock").requires(Unblock::canExecute)).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests(Unblock::suggestBlockedUsers).executes(Unblock::execute))).build();
    }

    private static boolean canExecute(CommandSourceStack css) {
        if (!(css.getSender() instanceof Player)) {
            return false;
        }
        return css.getSender().hasPermission(Constants.MESSAGE_BLOCK);
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            throw Exceptions.ERROR_MUST_BE_PLAYER.create();
        }
        Player playerSender = (Player)sender;
        String target = (String)ctx.getArgument("target", String.class);
        UnblockHandler.removeBlockedPlayer(playerSender, target);
        Unblock.sendSuccessMessage(playerSender, target);
        return 1;
    }

    private static void sendSuccessMessage(Player sender, String name) {
        sender.sendRichMessage(LocaleMessage.NO_LONGER_BLOCKING.getMessage(), new TagResolver[]{Placeholder.parsed((String)"name", (String)name)});
    }

    private static CompletableFuture<Suggestions> suggestBlockedUsers(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            return builder.buildFuture();
        }
        Player playerSender = (Player)sender;
        List<PlayerBlock> blockedPlayers = Cache.getBlockList(playerSender.getUniqueId());
        if (blockedPlayers.isEmpty()) {
            return builder.buildFuture();
        }
        for (PlayerBlock block : blockedPlayers) {
            if (block == null) continue;
            String blockReason = block.getBlockReason();
            if (blockReason == null || blockReason.isEmpty()) {
                builder.suggest(block.getBlockedPlayerName());
                continue;
            }
            builder.suggest(block.getBlockedPlayerName(), (Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)blockReason)));
        }
        return builder.buildFuture();
    }
}

