/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import simplexity.simplepms.commands.util.Exceptions;
import simplexity.simplepms.config.ConfigHandler;

public class OfflinePlayerArgument
implements CustomArgumentType<OfflinePlayer, String> {
    @NotNull
    public OfflinePlayer parse(@NotNull StringReader reader) throws CommandSyntaxException {
        String playerName = reader.readString();
        OfflinePlayer[] offlinePlayers = Bukkit.getOfflinePlayers();
        OfflinePlayer offlinePlayer = null;
        for (OfflinePlayer player : offlinePlayers) {
            if (player.getName() == null || player.getName().isEmpty() || !player.getName().equalsIgnoreCase(playerName)) continue;
            offlinePlayer = player;
            break;
        }
        if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore()) {
            throw Exceptions.ERROR_INVALID_USER.create((Object)playerName);
        }
        return offlinePlayer;
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        return StringArgumentType.greedyString();
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> suggestOnlinePlayers(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (!(object instanceof CommandSourceStack)) {
            return builder.buildFuture();
        }
        CommandSourceStack css = (CommandSourceStack)object;
        CommandSender sender = css.getSender();
        Player playerSender = null;
        if (sender instanceof Player) {
            playerSender = (Player)sender;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            String suggestion;
            if (playerSender != null && !playerSender.canSee(player) && !ConfigHandler.getInstance().canPlayersSendToHiddenPlayers() || !(suggestion = player.getName()).toLowerCase().contains(builder.getRemainingLowerCase())) continue;
            builder.suggest(suggestion, (Message)MessageComponentSerializer.message().serialize(player.displayName()));
        }
        return builder.buildFuture();
    }
}

