/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.commands.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import simplexity.simplepms.commands.util.Exceptions;
import simplexity.simplepms.config.ConfigHandler;
import simplexity.simplepms.logic.Constants;
import simplexity.simplepms.saving.Cache;
import simplexity.simplepms.saving.objects.PlayerBlock;
import simplexity.simplepms.saving.objects.PlayerSettings;

public class MessageChecks {
    public static void userChecks(CommandSender initiator, CommandSender target, String providedName) throws CommandSyntaxException {
        if (initiator instanceof Player) {
            Player playerInitiator = (Player)initiator;
            MessageChecks.ownMessagesDisabledCheck(playerInitiator);
            if (target instanceof Player) {
                Player playerTarget = (Player)target;
                MessageChecks.initiatorBlockedTargetCheck(playerInitiator, playerTarget);
                if (!initiator.hasPermission(Constants.ADMIN_OVERRIDE)) {
                    MessageChecks.targetCanGetMessageCheck(playerTarget);
                    MessageChecks.targetBlockedInitiatorCheck(playerInitiator, playerTarget);
                    MessageChecks.vanishCheck(playerInitiator, playerTarget, providedName);
                }
            } else {
                MessageChecks.canSendToConsole(providedName);
            }
        }
    }

    private static void vanishCheck(Player initiator, Player target, String providedName) throws CommandSyntaxException {
        if (ConfigHandler.getInstance().canPlayersSendToHiddenPlayers()) {
            return;
        }
        if (!initiator.canSee(target)) {
            throw Exceptions.ERROR_INVALID_USER.create((Object)providedName);
        }
    }

    private static void ownMessagesDisabledCheck(Player initiatingPlayer) throws CommandSyntaxException {
        PlayerSettings settings = Cache.getPlayerSettings(initiatingPlayer.getUniqueId());
        if (settings == null) {
            return;
        }
        if (settings.areMessagesDisabled()) {
            throw Exceptions.ERROR_YOUR_MESSAGES_ARE_DISABLED.create();
        }
    }

    private static void targetCanGetMessageCheck(Player targetPlayer) throws CommandSyntaxException {
        if (!targetPlayer.hasPermission(Constants.MESSAGE_RECEIVE)) {
            throw Exceptions.ERROR_TARGET_CANNOT_RECEIVE_MESSAGE.create();
        }
        PlayerSettings settings = Cache.getPlayerSettings(targetPlayer.getUniqueId());
        if (settings == null) {
            return;
        }
        if (settings.areMessagesDisabled()) {
            throw Exceptions.ERROR_TARGET_CANNOT_RECEIVE_MESSAGE.create();
        }
    }

    private static void targetBlockedInitiatorCheck(Player initiatingPlayer, Player targetPlayer) throws CommandSyntaxException {
        if (MessageChecks.userBlocked(targetPlayer, initiatingPlayer)) {
            throw Exceptions.ERROR_TARGET_CANNOT_RECEIVE_MESSAGE.create();
        }
    }

    private static void initiatorBlockedTargetCheck(Player initiatingPlayer, Player targetPlayer) throws CommandSyntaxException {
        if (MessageChecks.userBlocked(initiatingPlayer, targetPlayer)) {
            throw Exceptions.ERROR_CANNOT_MESSAGE_SOMEONE_YOU_HAVE_BLOCKED.create();
        }
    }

    private static void canSendToConsole(String providedName) throws CommandSyntaxException {
        if (!ConfigHandler.getInstance().canPlayersSendToConsole()) {
            throw Exceptions.ERROR_INVALID_USER.create((Object)providedName);
        }
    }

    private static boolean userBlocked(Player blocklistPlayer, Player potentialBlock) {
        List<PlayerBlock> playerBlocks = Cache.blockList.get(blocklistPlayer.getUniqueId());
        if (playerBlocks == null) {
            return false;
        }
        for (PlayerBlock playerBlock : playerBlocks) {
            if (!playerBlock.getBlockedPlayerUUID().equals(potentialBlock.getUniqueId())) continue;
            return true;
        }
        return false;
    }
}

