/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import simplexity.simplepms.SimplePMs;
import simplexity.simplepms.config.LocaleHandler;
import simplexity.simplepms.config.LocaleMessage;

public class ConfigHandler {
    private static ConfigHandler instance;
    private final Logger logger = SimplePMs.getInstance().getLogger();
    private boolean mysqlEnabled;
    private boolean playersSendToConsole;
    private boolean playersSendToHiddenPlayers;
    private boolean consoleHasSocialSpy;
    private boolean commandSpyEnabled;
    private boolean consoleHasCommandSpy;
    private boolean receiveSoundEnabled;
    private boolean sendSoundEnabled;
    private boolean spySoundEnabled;
    private NamespacedKey receiveSound = Registry.SOUNDS.getKey((Keyed)Sound.BLOCK_NOTE_BLOCK_XYLOPHONE);
    private NamespacedKey sendSound = Registry.SOUNDS.getKey((Keyed)Sound.ENTITY_ALLAY_ITEM_THROWN);
    private NamespacedKey spySound = Registry.SOUNDS.getKey((Keyed)Sound.ENTITY_ITEM_FRAME_ROTATE_ITEM);
    private float receivePitch;
    private float receiveVolume;
    private float sendPitch;
    private float sendVolume;
    private float spyPitch;
    private float spyVolume;
    private String mysqlIp;
    private String mysqlName;
    private String mysqlUsername;
    private String mysqlPassword;
    private String normalFormat;
    private String socialSpyFormat;
    private final List<String> validNamesForConsole = new ArrayList<String>();
    private final HashSet<String> commandsToSpy = new HashSet();

    public static ConfigHandler getInstance() {
        if (instance == null) {
            instance = new ConfigHandler();
        }
        return instance;
    }

    public void loadConfigValues() {
        SimplePMs.getInstance().reloadConfig();
        FileConfiguration config = SimplePMs.getInstance().getConfig();
        LocaleHandler.getInstance().reloadLocale();
        List commands = config.getStringList("command-spy.commands");
        List consoleNames = config.getStringList("valid-console-names");
        this.updateHashSet(this.commandsToSpy, commands);
        this.validateConsoleNames(consoleNames);
        this.normalFormat = config.getString("format.normal", "<displayname>");
        this.socialSpyFormat = config.getString("format.social-spy", "<username>");
        this.mysqlEnabled = config.getBoolean("mysql.enabled", false);
        this.commandSpyEnabled = config.getBoolean("command-spy.enabled", false);
        this.mysqlIp = config.getString("mysql.ip", "localhost:3306");
        this.mysqlName = config.getString("mysql.name", "homes");
        this.mysqlUsername = config.getString("mysql.username", "username1");
        this.mysqlPassword = config.getString("mysql.password", "badpassword!");
        this.playersSendToConsole = config.getBoolean("allow-messaging.console", true);
        this.playersSendToHiddenPlayers = config.getBoolean("allow-messaging.hidden-players", false);
        this.consoleHasSocialSpy = config.getBoolean("console-has-social-spy", true);
        this.consoleHasCommandSpy = config.getBoolean("console-has-command-spy", false);
        this.receiveSoundEnabled = config.getBoolean("sounds.received.enabled", false);
        this.sendSoundEnabled = config.getBoolean("sounds.sent.enabled", false);
        this.spySoundEnabled = config.getBoolean("sounds.spy.enabled", false);
        if (this.receiveSoundEnabled) {
            this.loadReceiveSoundInfo(config);
        }
        if (this.sendSoundEnabled) {
            this.loadSendSoundInfo(config);
        }
        if (this.spySoundEnabled) {
            this.loadSpySoundInfo(config);
        }
    }

    private void updateHashSet(HashSet<String> set, List<String> list) {
        set.clear();
        set.addAll(list);
    }

    private void loadReceiveSoundInfo(FileConfiguration config) {
        String soundString = config.getString("sounds.received.sound", "minecraft:block.note_block.xylophone");
        this.receiveSound = this.getValidSound(soundString, Registry.SOUNDS.getKey((Keyed)Sound.BLOCK_NOTE_BLOCK_XYLOPHONE));
        this.receivePitch = this.getValidFloat(config.getDouble("sounds.received.pitch", 1.8));
        this.receiveVolume = this.getValidFloat(config.getDouble("sounds.received.volume", 0.5));
    }

    private void loadSendSoundInfo(FileConfiguration config) {
        String soundString = config.getString("sounds.sent.sound", "minecraft:entity.allay.item_thrown");
        this.sendSound = this.getValidSound(soundString, Registry.SOUNDS.getKey((Keyed)Sound.ENTITY_ALLAY_ITEM_THROWN));
        this.sendPitch = this.getValidFloat(config.getDouble("sounds.sent.pitch", 1.8));
        this.sendVolume = this.getValidFloat(config.getDouble("sounds.sent.volume", 0.5));
    }

    private void loadSpySoundInfo(FileConfiguration config) {
        String soundString = config.getString("sounds.spy.sound", "minecraft:entity.item_frame.rotate_item");
        this.spySound = this.getValidSound(soundString, Registry.SOUNDS.getKey((Keyed)Sound.ENTITY_ITEM_FRAME_ROTATE_ITEM));
        this.spyPitch = this.getValidFloat(config.getDouble("sounds.spy.pitch", 1.8));
        this.spyVolume = this.getValidFloat(config.getDouble("sounds.spy.volume", 0.5));
    }

    private NamespacedKey getValidSound(String soundString, NamespacedKey defaultSound) {
        NamespacedKey key = NamespacedKey.fromString((String)soundString);
        if (key == null || Registry.SOUNDS.get(key) == null) {
            String warning = LocaleMessage.LOG_ERROR_SOUND_NOT_VALID.getMessage().replace("%sound-string%", soundString);
            String warning2 = LocaleMessage.LOG_ERROR_USING_DEFAULT_SOUND.getMessage().replace("%default-sound%", defaultSound.getKey());
            this.logger.warning(warning);
            this.logger.warning(warning2);
            return defaultSound;
        }
        return key;
    }

    private float getValidFloat(double numberToCheck) {
        if (numberToCheck <= 2.0 && numberToCheck >= 0.0) {
            return (float)numberToCheck;
        }
        String warning = LocaleMessage.LOG_ERROR_FLOAT_OUT_OF_RANGE.getMessage().replace("%number%", String.valueOf(numberToCheck));
        this.logger.warning(warning);
        this.logger.warning(LocaleMessage.LOG_ERROR_USING_DEFAULT_FLOAT.getMessage());
        return 1.0f;
    }

    private void validateConsoleNames(List<String> list) {
        this.validNamesForConsole.clear();
        for (String name : list) {
            this.validNamesForConsole.add(name.toLowerCase());
        }
    }

    public boolean isMysqlEnabled() {
        return this.mysqlEnabled;
    }

    public String getMysqlIp() {
        return this.mysqlIp;
    }

    public String getMysqlName() {
        return this.mysqlName;
    }

    public String getMysqlUsername() {
        return this.mysqlUsername;
    }

    public String getMysqlPassword() {
        return this.mysqlPassword;
    }

    public boolean canPlayersSendToConsole() {
        return this.playersSendToConsole;
    }

    public boolean canPlayersSendToHiddenPlayers() {
        return this.playersSendToHiddenPlayers;
    }

    public List<String> getValidNamesForConsole() {
        return this.validNamesForConsole;
    }

    public HashSet<String> getCommandsToSpy() {
        return this.commandsToSpy;
    }

    public boolean doesConsoleHaveSocialSpy() {
        return this.consoleHasSocialSpy;
    }

    public boolean doesConsoleHaveCommandSpy() {
        return this.consoleHasCommandSpy;
    }

    public boolean isCommandSpyEnabled() {
        return this.commandSpyEnabled;
    }

    public boolean receivingMessagePlaysSound() {
        return this.receiveSoundEnabled;
    }

    public boolean sendingMessagePlaysSound() {
        return this.sendSoundEnabled;
    }

    public boolean messagePlaysSoundForSpy() {
        return this.spySoundEnabled;
    }

    public String getNormalFormat() {
        return this.normalFormat;
    }

    public String getSocialSpyFormat() {
        return this.socialSpyFormat;
    }

    @NotNull
    public NamespacedKey getReceiveSound() {
        return this.receiveSound;
    }

    @NotNull
    public NamespacedKey getSendSound() {
        return this.sendSound;
    }

    @NotNull
    public NamespacedKey getSpySound() {
        return this.spySound;
    }

    public float getReceivePitch() {
        return this.receivePitch;
    }

    public float getReceiveVolume() {
        return this.receiveVolume;
    }

    public float getSendPitch() {
        return this.sendPitch;
    }

    public float getSendVolume() {
        return this.sendVolume;
    }

    public float getSpyPitch() {
        return this.spyPitch;
    }

    public float getSpyVolume() {
        return this.spyVolume;
    }
}

