/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import simplexity.simplepms.SimplePMs;
import simplexity.simplepms.config.LocaleMessage;

public class LocaleHandler {
    private static LocaleHandler instance;
    private final String fileName = "locale.yml";
    private final File dataFile = new File(SimplePMs.getInstance().getDataFolder(), "locale.yml");
    private FileConfiguration locale = new YamlConfiguration();

    private LocaleHandler() {
        try {
            this.dataFile.getParentFile().mkdirs();
            this.dataFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.reloadLocale();
    }

    public static LocaleHandler getInstance() {
        if (instance == null) {
            instance = new LocaleHandler();
        }
        return instance;
    }

    public void reloadLocale() {
        try {
            this.locale.load(this.dataFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        this.populateLocale();
        this.sortLocale();
        this.saveLocale();
    }

    private void populateLocale() {
        HashSet<LocaleMessage> missing = new HashSet<LocaleMessage>(Arrays.asList(LocaleMessage.values()));
        for (LocaleMessage localeMessage : LocaleMessage.values()) {
            if (!this.locale.contains(localeMessage.getPath())) continue;
            localeMessage.setMessage(this.locale.getString(localeMessage.getPath()));
            missing.remove((Object)localeMessage);
        }
        for (LocaleMessage localeMessage : missing) {
            this.locale.set(localeMessage.getPath(), (Object)localeMessage.getMessage());
        }
    }

    private void sortLocale() {
        YamlConfiguration newLocale = new YamlConfiguration();
        ArrayList keys = new ArrayList();
        keys.addAll(this.locale.getKeys(true));
        Collections.sort(keys);
        for (String key : keys) {
            newLocale.set(key, (Object)this.locale.getString(key));
        }
        this.locale = newLocale;
    }

    private void saveLocale() {
        try {
            this.locale.save(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

