/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.logic;

import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import simplexity.simplepms.SimplePMs;
import simplexity.simplepms.config.ConfigHandler;
import simplexity.simplepms.config.LocaleMessage;

public class MessageUtils {
    private static MessageUtils instance;
    private final MiniMessage miniMessage = SimplePMs.getMiniMessage();

    private MessageUtils() {
    }

    public static MessageUtils getInstance() {
        if (instance == null) {
            instance = new MessageUtils();
        }
        return instance;
    }

    public Component parseMessage(String localeMessage, @NotNull CommandSender initiator, @NotNull CommandSender target, String messageContent, boolean socialSpy) {
        Component senderComponent = this.getCommmandSenderComponent(initiator, socialSpy);
        Component targetComponent = this.getCommmandSenderComponent(target, socialSpy);
        return this.miniMessage.deserialize(localeMessage, new TagResolver[]{Placeholder.component((String)"initiator", (ComponentLike)senderComponent), Placeholder.component((String)"target", (ComponentLike)targetComponent), Placeholder.unparsed((String)"message", (String)messageContent)});
    }

    public Component parseMessage(String localeMessage, @NotNull CommandSender initiator, String command, String messageContent, boolean socialSpy) {
        Component senderComponent = this.getCommmandSenderComponent(initiator, socialSpy);
        return this.miniMessage.deserialize(localeMessage, new TagResolver[]{Placeholder.component((String)"initiator", (ComponentLike)senderComponent), Placeholder.unparsed((String)"command", (String)command), Placeholder.unparsed((String)"message", (String)messageContent)});
    }

    private Component getCommmandSenderComponent(CommandSender sender, boolean socialSpy) {
        if (!(sender instanceof Player)) {
            if (socialSpy) {
                return this.miniMessage.deserialize((Object)LocaleMessage.CONSOLE_NAME_SOCIAL_SPY.getMessage());
            }
            return this.miniMessage.deserialize((Object)LocaleMessage.CONSOLE_SENDER_NAME.getMessage());
        }
        Player player = (Player)sender;
        if (!SimplePMs.isPapiEnabled()) {
            if (socialSpy) {
                return this.parseName(player, ConfigHandler.getInstance().getSocialSpyFormat());
            }
            return this.parseName(player, ConfigHandler.getInstance().getNormalFormat());
        }
        if (socialSpy) {
            return this.parsePapiName(player, ConfigHandler.getInstance().getSocialSpyFormat());
        }
        return this.parsePapiName(player, ConfigHandler.getInstance().getNormalFormat());
    }

    private Component parseName(Player player, String message) {
        return this.miniMessage.deserialize(message, new TagResolver[]{Placeholder.component((String)"displayname", (ComponentLike)player.displayName()), Placeholder.unparsed((String)"username", (String)player.getName())});
    }

    private Component parsePapiName(Player player, String message) {
        return this.miniMessage.deserialize(message, new TagResolver[]{this.papiTag(player), Placeholder.component((String)"displayname", (ComponentLike)player.displayName()), Placeholder.unparsed((String)"username", (String)player.getName())});
    }

    public TagResolver papiTag(Player player) {
        if (player == null) {
            return TagResolver.empty();
        }
        return TagResolver.resolver((String)"papi", (argumentQueue, context) -> {
            String papiPlaceholder = argumentQueue.popOr("PLACEHOLDER API NEEDS ARGUMENT").value();
            String parsedPlaceholder = PlaceholderAPI.setPlaceholders((Player)player, (String)("%" + papiPlaceholder + "%"));
            TextComponent componentPlaceholder = LegacyComponentSerializer.legacySection().deserialize(parsedPlaceholder);
            return Tag.inserting((Component)componentPlaceholder);
        });
    }
}

