/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.logic;

import java.util.HashMap;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import simplexity.simplepms.SimplePMs;
import simplexity.simplepms.config.ConfigHandler;
import simplexity.simplepms.config.LocaleMessage;
import simplexity.simplepms.events.PrivateMessageEvent;
import simplexity.simplepms.logic.MessageUtils;
import simplexity.simplepms.logic.SpyHandler;
import simplexity.simplepms.saving.Cache;

public class PMHandler {
    public static final HashMap<CommandSender, CommandSender> lastMessaged = new HashMap();

    public static void handlePrivateMessage(CommandSender initiator, CommandSender target, String messageContent) {
        PrivateMessageEvent messageEvent = PMHandler.callPMEvent(initiator, target, messageContent);
        if (messageEvent.isCancelled()) {
            return;
        }
        initiator = messageEvent.getInitiator();
        target = messageEvent.getRecipient();
        messageContent = messageEvent.getMessageContent();
        PMHandler.handleMessageSend(initiator, target, messageContent);
        PMHandler.handleMessageReceive(initiator, target, messageContent);
        lastMessaged.put(initiator, target);
        lastMessaged.put(target, initiator);
        if (!(initiator instanceof Player) || !(target instanceof Player)) {
            SpyHandler.handleConsoleSpy(messageEvent);
        } else {
            SpyHandler.handleSocialSpy(messageEvent);
        }
    }

    private static void handleMessageSend(CommandSender initiator, CommandSender target, String messageContent) {
        initiator.sendMessage(MessageUtils.getInstance().parseMessage(LocaleMessage.FORMAT_SENT.getMessage(), initiator, target, messageContent, false));
        if (!ConfigHandler.getInstance().sendingMessagePlaysSound()) {
            return;
        }
        if (!(initiator instanceof Player)) {
            return;
        }
        Player player = (Player)initiator;
        Sound sound = (Sound)Registry.SOUNDS.get(ConfigHandler.getInstance().getSendSound());
        if (sound == null) {
            return;
        }
        player.playSound((Entity)player, sound, ConfigHandler.getInstance().getSendVolume(), ConfigHandler.getInstance().getSendPitch());
    }

    private static void handleMessageReceive(CommandSender initiator, CommandSender target, String messageContent) {
        target.sendMessage(MessageUtils.getInstance().parseMessage(LocaleMessage.FORMAT_RECEIVED.getMessage(), initiator, target, messageContent, false));
        if (!ConfigHandler.getInstance().receivingMessagePlaysSound()) {
            return;
        }
        if (!(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        Sound sound = (Sound)Registry.SOUNDS.get(ConfigHandler.getInstance().getReceiveSound());
        if (sound == null) {
            return;
        }
        player.playSound((Entity)player, sound, ConfigHandler.getInstance().getReceiveVolume(), ConfigHandler.getInstance().getReceivePitch());
    }

    private static PrivateMessageEvent callPMEvent(CommandSender initiator, CommandSender target, String messageContent) {
        PrivateMessageEvent messageEvent = new PrivateMessageEvent(initiator, target, messageContent, Cache.getSpyingPlayers());
        SimplePMs.getInstance().getServer().getPluginManager().callEvent((Event)messageEvent);
        return messageEvent;
    }
}

