/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.logic;

import net.kyori.adventure.text.Component;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import simplexity.simplepms.SimplePMs;
import simplexity.simplepms.config.ConfigHandler;
import simplexity.simplepms.config.LocaleMessage;
import simplexity.simplepms.events.PrivateMessageEvent;
import simplexity.simplepms.logic.Constants;
import simplexity.simplepms.logic.MessageUtils;
import simplexity.simplepms.saving.Cache;

public class SpyHandler {
    private static final CommandSender console = SimplePMs.getPMConsoleSender();

    public static void sendCommandSpy(CommandSender initiator, String command, String messageContent) {
        Component parsedMessage = MessageUtils.getInstance().parseMessage(LocaleMessage.FORMAT_COMMAND_SPY.getMessage(), initiator, command, messageContent, true);
        if (ConfigHandler.getInstance().doesConsoleHaveCommandSpy()) {
            console.sendMessage(parsedMessage);
        }
        if (initiator.hasPermission(Constants.BYPASS_COMMAND_SPY)) {
            return;
        }
        for (Player spyingPlayer : Cache.getSpyingPlayers()) {
            if (initiator.equals((Object)spyingPlayer) || !spyingPlayer.hasPermission(Constants.ADMIN_SOCIAL_SPY)) continue;
            spyingPlayer.sendMessage(parsedMessage);
            SpyHandler.playSpySound(spyingPlayer);
        }
    }

    public static void handleSocialSpy(PrivateMessageEvent messageEvent) {
        Player initiatorPlayer = (Player)messageEvent.getInitiator();
        Player targetPlayer = (Player)messageEvent.getRecipient();
        Component parsedMessage = MessageUtils.getInstance().parseMessage(LocaleMessage.FORMAT_SOCIAL_SPY.getMessage(), (CommandSender)initiatorPlayer, (CommandSender)targetPlayer, messageEvent.getMessageContent(), true);
        if (ConfigHandler.getInstance().doesConsoleHaveSocialSpy()) {
            console.sendMessage(parsedMessage);
        }
        if (initiatorPlayer.hasPermission(Constants.BYPASS_SOCIAL_SPY) || targetPlayer.hasPermission(Constants.BYPASS_SOCIAL_SPY)) {
            return;
        }
        for (Player spyingPlayer : messageEvent.getSpyingPlayers()) {
            if (!spyingPlayer.hasPermission(Constants.ADMIN_SOCIAL_SPY) || spyingPlayer.equals((Object)initiatorPlayer) || spyingPlayer.equals((Object)targetPlayer)) continue;
            spyingPlayer.sendMessage(parsedMessage);
            SpyHandler.playSpySound(spyingPlayer);
        }
    }

    public static void handleConsoleSpy(PrivateMessageEvent messageEvent) {
        Component parsedMessage = MessageUtils.getInstance().parseMessage(LocaleMessage.FORMAT_SOCIAL_SPY.getMessage(), messageEvent.getInitiator(), messageEvent.getRecipient(), messageEvent.getMessageContent(), true);
        for (Player spyingPlayer : messageEvent.getSpyingPlayers()) {
            if (!spyingPlayer.hasPermission(Constants.ADMIN_CONSOLE_SPY) || spyingPlayer.equals((Object)messageEvent.getInitiator()) || spyingPlayer.equals((Object)messageEvent.getRecipient())) continue;
            spyingPlayer.sendMessage(parsedMessage);
            SpyHandler.playSpySound(spyingPlayer);
        }
    }

    private static void playSpySound(Player spyingPlayer) {
        if (!ConfigHandler.getInstance().messagePlaysSoundForSpy()) {
            return;
        }
        Sound sound = (Sound)Registry.SOUNDS.get(ConfigHandler.getInstance().getSpySound());
        if (sound == null) {
            return;
        }
        spyingPlayer.playSound((Entity)spyingPlayer, sound, ConfigHandler.getInstance().getSpyVolume(), ConfigHandler.getInstance().getSpyPitch());
    }
}

