/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.saving;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import simplexity.simplepms.SimplePMs;
import simplexity.simplepms.config.LocaleMessage;
import simplexity.simplepms.saving.SqlHandler;
import simplexity.simplepms.saving.objects.PlayerBlock;
import simplexity.simplepms.saving.objects.PlayerSettings;

public class Cache {
    public static final HashMap<UUID, List<PlayerBlock>> blockList = new HashMap();
    public static final HashMap<UUID, PlayerSettings> playerSettings = new HashMap();
    public static final HashSet<Player> spyingPlayers = new HashSet();

    public static List<PlayerBlock> getBlockList(UUID uuid) {
        return blockList.get(uuid);
    }

    public static PlayerSettings getPlayerSettings(UUID uuid) {
        return playerSettings.get(uuid);
    }

    public static void populateCache(UUID uuid, Player player, boolean hasSpyPerms) {
        Bukkit.getScheduler().runTaskAsynchronously(SimplePMs.getInstance(), () -> {
            SqlHandler.getInstance().getBlockedPlayers(uuid).thenAccept(blocklist -> {
                blockList.put(uuid, (List<PlayerBlock>)blocklist);
                Cache.populateNullNames(uuid);
            });
            SqlHandler.getInstance().getSettings(uuid).thenAccept(settings -> {
                playerSettings.put(uuid, (PlayerSettings)settings);
                if (hasSpyPerms && settings.isSocialSpyEnabled()) {
                    spyingPlayers.add(player);
                }
            });
        });
    }

    public static void removePlayerSettingsFromCache(UUID uuid) {
        playerSettings.remove(uuid);
    }

    public static void removeBlockListFromCache(UUID uuid) {
        playerSettings.remove(uuid);
    }

    public static void updateSocialSpySettings(UUID uuid, boolean socialSpy) {
        PlayerSettings settings = playerSettings.get(uuid);
        settings.setSocialSpyEnabled(socialSpy);
        playerSettings.put(uuid, settings);
        SqlHandler.getInstance().updateSettings(uuid, settings.isSocialSpyEnabled(), settings.areMessagesDisabled());
    }

    public static void updateMessageSettings(UUID uuid, boolean messageDisabled) {
        PlayerSettings settings = playerSettings.get(uuid);
        settings.setMessagesDisabled(messageDisabled);
        playerSettings.put(uuid, settings);
        SqlHandler.getInstance().updateSettings(uuid, settings.isSocialSpyEnabled(), settings.areMessagesDisabled());
    }

    public static void addBlockedUser(UUID uuid, PlayerBlock playerBlock) {
        Cache.removeCachedDuplicates(uuid, playerBlock.getBlockedPlayerUUID());
        List<PlayerBlock> blockedPlayers = blockList.get(uuid);
        blockedPlayers.add(playerBlock);
        blockList.put(uuid, blockedPlayers);
        SqlHandler.getInstance().addBlockedPlayer(uuid, playerBlock.getBlockedPlayerUUID(), playerBlock.getBlockedPlayerName(), playerBlock.getBlockReason());
    }

    public static void removeBlockedUser(UUID uuid, UUID blockedPlayerUuid) {
        List<PlayerBlock> userBlockList = blockList.get(uuid);
        for (PlayerBlock block : userBlockList) {
            if (!block.getBlockedPlayerUUID().equals(blockedPlayerUuid)) continue;
            userBlockList.remove(block);
            break;
        }
        blockList.put(uuid, userBlockList);
        SqlHandler.getInstance().removeBlockedPlayer(uuid, blockedPlayerUuid);
    }

    private static void removeCachedDuplicates(UUID blockingUuid, UUID blockedUuid) {
        List<PlayerBlock> blockedPlayers = blockList.get(blockingUuid);
        if (blockedPlayers == null) {
            blockedPlayers = new ArrayList<PlayerBlock>();
        }
        blockedPlayers.removeIf(block -> block.getBlockedPlayerUUID().equals(blockedUuid));
        blockList.put(blockingUuid, blockedPlayers);
    }

    private static void populateNullNames(UUID uuidToCheck) {
        List<PlayerBlock> playerBlocks = blockList.get(uuidToCheck);
        if (playerBlocks == null || playerBlocks.isEmpty()) {
            return;
        }
        for (PlayerBlock block : playerBlocks) {
            if (block.getBlockedPlayerName() != null && !block.getBlockedPlayerName().isEmpty()) continue;
            String newName = Bukkit.getOfflinePlayer((UUID)block.getBlockedPlayerUUID()).getName();
            if (newName == null) {
                newName = LocaleMessage.ERROR_NAME_NOT_FOUND.getMessage();
            }
            block.setBlockedPlayerName(newName);
        }
        blockList.put(uuidToCheck, playerBlocks);
    }

    public static Set<Player> getSpyingPlayers() {
        return spyingPlayers;
    }
}

