/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplepms.saving;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;
import simplexity.simplepms.SimplePMs;
import simplexity.simplepms.config.ConfigHandler;
import simplexity.simplepms.saving.objects.PlayerBlock;
import simplexity.simplepms.saving.objects.PlayerSettings;

public class SqlHandler {
    private static SqlHandler instance;
    private static final HikariConfig hikariConfig;
    private static HikariDataSource dataSource;
    private static final Plugin plugin;
    private final Logger logger = SimplePMs.getInstance().getSLF4JLogger();

    private SqlHandler() {
    }

    public static SqlHandler getInstance() {
        if (instance == null) {
            instance = new SqlHandler();
        }
        return instance;
    }

    public void init() {
        this.setupConfig();
        try (Connection connection = SqlHandler.getConnection();){
            PreparedStatement blocklistInitStatement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS blocklist (\n   player_uuid VARCHAR (36) NOT NULL,\n   blocked_player_uuid VARCHAR(36) NOT NULL,\n   blocked_player_name VARCHAR(256),\n   block_reason VARCHAR(256),\n   PRIMARY KEY (player_uuid, blocked_player_uuid)\n);");
            blocklistInitStatement.execute();
            PreparedStatement playerSettingsInitStatement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS settings (\n   player_uuid VARCHAR (36) NOT NULL PRIMARY KEY,\n   socialspy_enabled BOOLEAN NOT NULL,\n   messages_disabled BOOLEAN NOT NULL\n);");
            playerSettingsInitStatement.execute();
            this.updateDatabaseColumns().join();
        }
        catch (SQLException e) {
            this.logger.warn("Failed to connect to database: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void reloadDatabase() {
        this.logger.info("Reconnecting to SimplePMs database...");
        this.shutdownConnection();
        this.setupConfig();
        this.logger.info("Database reloaded successfully");
    }

    public CompletableFuture<PlayerSettings> getSettings(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            String queryString = "SELECT socialspy_enabled, messages_disabled FROM settings WHERE player_uuid = ?;";
            PlayerSettings settings = null;
            try (Connection connection = SqlHandler.getConnection();){
                PreparedStatement statement = connection.prepareStatement(queryString);
                statement.setString(1, String.valueOf(playerUUID));
                try (ResultSet resultSet = statement.executeQuery();){
                    if (!resultSet.next()) {
                        settings = new PlayerSettings(playerUUID);
                        this.updateSettings(playerUUID, settings.isSocialSpyEnabled(), settings.areMessagesDisabled());
                    } else {
                        boolean socialSpy = resultSet.getBoolean("socialspy_enabled");
                        boolean messagesDisabled = resultSet.getBoolean("messages_disabled");
                        settings = new PlayerSettings(playerUUID, socialSpy, messagesDisabled);
                    }
                }
            }
            catch (SQLException e) {
                this.logger.warn("Failed to retrieve settings from database: {}", (Object)e.getMessage(), (Object)e);
            }
            return settings;
        });
    }

    public CompletableFuture<List<PlayerBlock>> getBlockedPlayers(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            String queryString = "SELECT blocked_player_uuid, block_reason, blocked_player_name from blocklist WHERE player_uuid = ?;";
            ArrayList<PlayerBlock> blockedPlayers = new ArrayList<PlayerBlock>();
            try (Connection connection = SqlHandler.getConnection();){
                PreparedStatement statement = connection.prepareStatement(queryString);
                statement.setString(1, String.valueOf(playerUUID));
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        UUID blockedPlayerUUID = UUID.fromString(resultSet.getString("blocked_player_uuid"));
                        String blockedPlayerName = resultSet.getString("blocked_player_name");
                        String reason = resultSet.getString("block_reason");
                        PlayerBlock block = new PlayerBlock(playerUUID, blockedPlayerName, blockedPlayerUUID, reason);
                        blockedPlayers.add(block);
                    }
                }
            }
            catch (SQLException e) {
                this.logger.warn("Failed to get blocked players: {}", (Object)e.getMessage(), (Object)e);
            }
            return blockedPlayers;
        });
    }

    public void addBlockedPlayer(UUID playerUUID, UUID blockedPlayerUUID, String blockedPlayerName, String reason) {
        Bukkit.getScheduler().runTaskAsynchronously(plugin, () -> {
            String queryString = "REPLACE INTO blocklist (player_uuid, blocked_player_uuid, blocked_player_name, block_reason) VALUES (?, ?, ?, ?);";
            try (Connection connection = SqlHandler.getConnection();){
                PreparedStatement statement = connection.prepareStatement(queryString);
                statement.setString(1, String.valueOf(playerUUID));
                statement.setString(2, String.valueOf(blockedPlayerUUID));
                statement.setString(3, blockedPlayerName);
                statement.setString(4, reason);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.logger.warn("Failed to add blocked player: {}", (Object)e.getMessage(), (Object)e);
                e.printStackTrace();
            }
        });
    }

    public void removeBlockedPlayer(UUID playerUUID, UUID blockedPlayerUUID) {
        Bukkit.getScheduler().runTaskAsynchronously(plugin, () -> {
            String queryString = "DELETE FROM blocklist WHERE player_uuid = ? and blocked_player_uuid = ?;";
            try (Connection connection = SqlHandler.getConnection();){
                PreparedStatement statement = connection.prepareStatement(queryString);
                statement.setString(1, String.valueOf(playerUUID));
                statement.setString(2, String.valueOf(blockedPlayerUUID));
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.logger.warn("Failed to remove blocked player: {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }

    public void updateSettings(UUID playerUUID, boolean socialSpyEnabled, boolean messagesDisabled) {
        Bukkit.getScheduler().runTaskAsynchronously(plugin, () -> {
            String queryString = "REPLACE INTO settings (player_uuid, socialspy_enabled, messages_disabled) VALUES (?, ?, ?);";
            try (Connection connection = SqlHandler.getConnection();){
                PreparedStatement statement = connection.prepareStatement(queryString);
                statement.setString(1, String.valueOf(playerUUID));
                statement.setBoolean(2, socialSpyEnabled);
                statement.setBoolean(3, messagesDisabled);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.logger.warn("Failed to update settings to database: {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }

    private CompletableFuture<Boolean> updateDatabaseColumns() {
        return CompletableFuture.supplyAsync(() -> {
            String tableName = "blocklist";
            String columnName = "blocked_player_name";
            try {
                boolean columnExists = ConfigHandler.getInstance().isMysqlEnabled() ? this.doesMysqlColumnExist(tableName, columnName).get().booleanValue() : this.doesSqliteColumnExist(tableName, columnName).get().booleanValue();
                if (!columnExists) {
                    this.addColumn(tableName, columnName, "VARCHAR(256)", "");
                }
            }
            catch (Exception e) {
                this.logger.warn("Unable to update database table: {} column: {}, error: {}", tableName, columnName, e.getMessage(), e);
                return false;
            }
            return true;
        });
    }

    private CompletableFuture<Boolean> doesSqliteColumnExist(String tableName, String columnName) {
        return CompletableFuture.supplyAsync(() -> {
            String query = "PRAGMA table_info(" + tableName + ")";
            try (Connection connection = SqlHandler.getConnection();){
                PreparedStatement statement = connection.prepareStatement(query);
                ResultSet resultSet = statement.executeQuery();
                do {
                    if (!resultSet.next()) return false;
                } while (!columnName.equalsIgnoreCase(resultSet.getString("name")));
                Boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                this.logger.warn("Failed to to check for column {} in table {}: {}", columnName, tableName, e.getMessage(), e);
            }
            return false;
        });
    }

    private CompletableFuture<Boolean> doesMysqlColumnExist(String tableName, String columnName) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block8: {
                Connection connection = SqlHandler.getConnection();
                try {
                    DatabaseMetaData metaData = connection.getMetaData();
                    ResultSet resultSet = metaData.getColumns(null, null, tableName, columnName);
                    bl = resultSet.next();
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.logger.warn("Failed to check for column {} in table {}: {}", columnName, tableName, e.getMessage(), e);
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    private void addColumn(String tableName, String columnName, String dataType, String constraints) {
        String query = String.format("ALTER TABLE %s ADD COLUMN %s %s %s;", tableName, columnName, dataType, constraints);
        try (Connection connection = SqlHandler.getConnection();){
            PreparedStatement statement = connection.prepareStatement(query);
            statement.executeUpdate();
            this.logger.info("Added new column '{}' to table '{}'", (Object)columnName, (Object)tableName);
        }
        catch (SQLException e) {
            this.logger.warn("Failed to add new column {} to table {}: {}", columnName, tableName, e.getMessage(), e);
        }
    }

    private void setupConfig() {
        if (!ConfigHandler.getInstance().isMysqlEnabled()) {
            hikariConfig.setJdbcUrl("jdbc:sqlite:" + String.valueOf(SimplePMs.getInstance().getDataFolder()) + "/simple-pms.db");
            hikariConfig.setConnectionTestQuery("PRAGMA journal_mode = WAL;");
            dataSource = new HikariDataSource(hikariConfig);
            return;
        }
        hikariConfig.setJdbcUrl("jdbc:mysql://" + ConfigHandler.getInstance().getMysqlIp() + "/" + ConfigHandler.getInstance().getMysqlName());
        hikariConfig.setUsername(ConfigHandler.getInstance().getMysqlUsername());
        hikariConfig.setPassword(ConfigHandler.getInstance().getMysqlPassword());
        dataSource = new HikariDataSource(hikariConfig);
    }

    private static Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }

    public void shutdownConnection() {
        if (dataSource == null || dataSource.isClosed()) {
            return;
        }
        dataSource.close();
        dataSource = null;
        this.logger.info("Closed existing database connection");
    }

    static {
        hikariConfig = new HikariConfig();
        plugin = SimplePMs.getInstance();
    }
}

