/*
 * Decompiled with CFR 0.152.
 */
package com.klyroth.placement.placementPlugin;

import com.klyroth.placement.placementPlugin.commands.ClearCommand;
import com.klyroth.placement.placementPlugin.commands.FarmPlaceCommand;
import com.klyroth.placement.placementPlugin.commands.RadiusCommand;
import com.klyroth.placement.placementPlugin.commands.RedoCommand;
import com.klyroth.placement.placementPlugin.commands.UndoCommand;
import com.klyroth.placement.placementPlugin.config.ConfigManager;
import com.klyroth.placement.placementPlugin.gui.GuiManager;
import com.klyroth.placement.placementPlugin.listener.GuiListener;
import com.klyroth.placement.placementPlugin.listener.PlaceListener;
import com.klyroth.placement.placementPlugin.listener.QuitListener;
import com.klyroth.placement.placementPlugin.service.ContextService;
import com.klyroth.placement.placementPlugin.utils.BlockBatcher;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlacementPlugin
extends JavaPlugin {
    private static PlacementPlugin instance;
    private ConfigManager config;
    private ContextService context;
    private GuiManager gui;
    private BlockBatcher batcher;
    private final String prefix = "\u00a77[\u00a7ePlacement\u00a77]\u00a78 \u00bb \u00a77";

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        instance = this;
        this.config = new ConfigManager((Plugin)this);
        this.context = new ContextService(this.config);
        this.gui = new GuiManager(this.config);
        this.batcher = new BlockBatcher();
        this.getCommand("farmplace").setExecutor((CommandExecutor)new FarmPlaceCommand(this.gui));
        this.getCommand("pc").setExecutor((CommandExecutor)new ClearCommand(this.context));
        this.getCommand("pradius").setExecutor((CommandExecutor)new RadiusCommand(this.context, this.config));
        this.getCommand("plundo").setExecutor((CommandExecutor)new UndoCommand(this.context));
        this.getCommand("plredo").setExecutor((CommandExecutor)new RedoCommand(this.context));
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(this.context, this.config), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlaceListener(this.context, this.config, this.batcher), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new QuitListener(this.context), (Plugin)this);
    }

    public void onDisable() {
    }

    public static PlacementPlugin getInstance() {
        return instance;
    }

    public String getPrefix() {
        return "\u00a77[\u00a7ePlacement\u00a77]\u00a78 \u00bb \u00a77";
    }
}

