/*
 * Decompiled with CFR 0.152.
 */
package com.klyroth.placement.placementPlugin.commands;

import com.klyroth.placement.placementPlugin.PlacementPlugin;
import com.klyroth.placement.placementPlugin.config.ConfigManager;
import com.klyroth.placement.placementPlugin.service.ContextService;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RadiusCommand
implements CommandExecutor {
    private final ContextService ctx;
    private final ConfigManager cfg;

    public RadiusCommand(ContextService ctx, ConfigManager cfg) {
        this.ctx = ctx;
        this.cfg = cfg;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player p = (Player)sender;
        if (!p.hasPermission("farmplace.radius")) {
            p.sendMessage(PlacementPlugin.getInstance().getPrefix() + "\u00a7cYou do not have permission to do that.");
            return true;
        }
        if (args.length != 1) {
            p.sendMessage(PlacementPlugin.getInstance().getPrefix() + "\u00a7eUse: /pradius <1\u2013\" + cfg.getMaxRadius() + \">");
            return false;
        }
        try {
            int r = Integer.parseInt(args[0]);
            if (r < 1 || r > this.cfg.getMaxRadius()) {
                throw new NumberFormatException();
            }
            this.ctx.setRadius(p.getUniqueId(), r);
            p.sendTitle("", "\u00a7eRadius: \u00a7a" + r, 5, 40, 5);
        }
        catch (NumberFormatException ex) {
            p.sendMessage(PlacementPlugin.getInstance().getPrefix() + "\u00a7cInvalid number (1\u2013\" + cfg.getMaxRadius() + \").");
        }
        return true;
    }
}

