/*
 * Decompiled with CFR 0.152.
 */
package com.klyroth.placement.placementPlugin.commands;

import com.klyroth.placement.placementPlugin.PlacementPlugin;
import com.klyroth.placement.placementPlugin.models.BlockChange;
import com.klyroth.placement.placementPlugin.models.ChangeOperation;
import com.klyroth.placement.placementPlugin.service.ContextService;
import com.klyroth.placement.placementPlugin.utils.BlockBatcher;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RedoCommand
implements CommandExecutor {
    private final ContextService ctx;

    public RedoCommand(ContextService ctx) {
        this.ctx = ctx;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player p = (Player)sender;
        if (!this.ctx.hasRedo(p.getUniqueId())) {
            p.sendMessage(PlacementPlugin.getInstance().getPrefix() + "\u00a7cNothing to restore.");
            return true;
        }
        ChangeOperation op = this.ctx.popRedo(p.getUniqueId());
        List<BlockChange> redoChanges = op.getChanges().stream().map(c -> new BlockChange(c.getWorld(), c.getX(), c.getY(), c.getZ(), op.getNewMaterial())).collect(Collectors.toList());
        BlockBatcher.applyChangeBatch(redoChanges);
        this.ctx.pushOperation(p.getUniqueId(), op);
        p.sendMessage(PlacementPlugin.getInstance().getPrefix() + "\u00a7aPlacement restored.");
        return true;
    }
}

