/*
 * Decompiled with CFR 0.152.
 */
package com.klyroth.placement.placementPlugin.commands;

import com.klyroth.placement.placementPlugin.PlacementPlugin;
import com.klyroth.placement.placementPlugin.models.ChangeOperation;
import com.klyroth.placement.placementPlugin.service.ContextService;
import com.klyroth.placement.placementPlugin.utils.BlockBatcher;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UndoCommand
implements CommandExecutor {
    private final ContextService ctx;

    public UndoCommand(ContextService ctx) {
        this.ctx = ctx;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player p = (Player)sender;
        if (!this.ctx.hasUndo(p.getUniqueId())) {
            p.sendMessage(PlacementPlugin.getInstance().getPrefix() + "\u00a7cNothing to undo.");
            return true;
        }
        ChangeOperation op = this.ctx.popUndo(p.getUniqueId());
        BlockBatcher.applyChangeBatch(op.getChanges());
        this.ctx.pushRedo(p.getUniqueId(), op);
        p.sendMessage(PlacementPlugin.getInstance().getPrefix() + "\u00a7aLast placement undone.");
        return true;
    }
}

