/*
 * Decompiled with CFR 0.152.
 */
package com.klyroth.placement.placementPlugin.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private final Plugin plugin;
    private final Map<Material, String> farmItems = new LinkedHashMap<Material, String>();
    private int guiSize;
    private int defaultRadius;
    private int maxRadius;
    private String guiTitle;

    public ConfigManager(Plugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        this.plugin.reloadConfig();
        FileConfiguration cfg = this.plugin.getConfig();
        this.guiTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)cfg.getString("gui-title", "&6&lFarmPlace"));
        int size = cfg.getInt("gui-size", 9);
        if (size < 9 || size % 9 != 0 || size > 54) {
            this.plugin.getLogger().warning("Invalid gui-size (" + size + "), setting to 9");
            size = 9;
        }
        this.guiSize = size;
        int defR = cfg.getInt("default-radius", 1);
        int maxR = cfg.getInt("max-radius", 20);
        if (defR < 1) {
            defR = 1;
        }
        if (maxR < defR) {
            this.plugin.getLogger().warning("max-radius < default-radius, setze max-radius = default-radius");
            maxR = defR;
        }
        this.defaultRadius = defR;
        this.maxRadius = maxR;
        this.farmItems.clear();
        ConfigurationSection section = cfg.getConfigurationSection("farm-items");
        if (section == null) {
            this.plugin.getLogger().warning("Section 'farm-items' missing in config.yml \u2013 no items loaded!");
        } else {
            this.plugin.getLogger().info("Loading farm-items:");
            for (String key : section.getKeys(false)) {
                try {
                    Material mat = Material.valueOf((String)key.trim().toUpperCase());
                    String raw = section.getString(key, key);
                    String name = ChatColor.translateAlternateColorCodes((char)'&', (String)raw);
                    this.farmItems.put(mat, name);
                    this.plugin.getLogger().info("  - " + String.valueOf(mat) + " -> '" + name + "'");
                }
                catch (IllegalArgumentException ex) {
                    this.plugin.getLogger().warning("  invalid material in farm-items: '" + key + "'");
                }
            }
            if (this.farmItems.isEmpty()) {
                this.plugin.getLogger().warning("No valid items entered in 'farm-items!");
            }
        }
    }

    public Map<Material, String> getFarmItems() {
        return this.farmItems;
    }

    public int getGuiSize() {
        return this.guiSize;
    }

    public String getGuiTitle() {
        return this.guiTitle;
    }

    public int getDefaultRadius() {
        return this.defaultRadius;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }
}

