/*
 * Decompiled with CFR 0.152.
 */
package com.klyroth.placement.placementPlugin.gui;

import com.klyroth.placement.placementPlugin.PlacementPlugin;
import com.klyroth.placement.placementPlugin.config.ConfigManager;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuiManager {
    private final ConfigManager cfg;

    public GuiManager(ConfigManager cfg) {
        this.cfg = cfg;
    }

    public Inventory createFarmGui() {
        Inventory inv = Bukkit.createInventory(null, (int)this.cfg.getGuiSize(), (String)this.cfg.getGuiTitle());
        int slot = 0;
        for (Map.Entry<Material, String> entry : this.cfg.getFarmItems().entrySet()) {
            ItemStack icon;
            if (slot >= this.cfg.getGuiSize()) break;
            Material mat = entry.getKey();
            String displayName = entry.getValue();
            if (mat == Material.WATER) {
                icon = new ItemStack(Material.WATER_BUCKET);
            } else if (mat == Material.LAVA) {
                icon = new ItemStack(Material.LAVA_BUCKET);
            } else {
                try {
                    icon = new ItemStack(mat);
                }
                catch (IllegalArgumentException ex) {
                    PlacementPlugin.getInstance().getLogger().warning("GuiManager: Skipping invalid material: " + String.valueOf(mat));
                    continue;
                }
            }
            ItemMeta meta = icon.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(displayName);
                icon.setItemMeta(meta);
            }
            inv.setItem(slot++, icon);
        }
        return inv;
    }
}

