/*
 * Decompiled with CFR 0.152.
 */
package com.klyroth.placement.placementPlugin.listener;

import com.klyroth.placement.placementPlugin.PlacementPlugin;
import com.klyroth.placement.placementPlugin.config.ConfigManager;
import com.klyroth.placement.placementPlugin.service.ContextService;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuiListener
implements Listener {
    private final ContextService ctx;
    private final ConfigManager cfg;

    public GuiListener(ContextService ctx, ConfigManager cfg) {
        this.ctx = ctx;
        this.cfg = cfg;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (!e.getView().getTitle().equals(this.cfg.getGuiTitle())) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        ItemStack[] contents = p.getInventory().getContents();
        for (int slot = 0; slot < contents.length; ++slot) {
            ItemStack item = contents[slot];
            if (item == null || item.getType() != Material.BLAZE_ROD || !item.hasItemMeta() || !ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).equals("Placeler")) continue;
            p.getInventory().setItem(slot, null);
        }
        ItemStack rod = new ItemStack(Material.BLAZE_ROD);
        ItemMeta meta = rod.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Placeler");
        rod.setItemMeta(meta);
        UUID uid = p.getUniqueId();
        this.ctx.setPlaceler(uid, clicked);
        p.getInventory().addItem(new ItemStack[]{rod});
        p.closeInventory();
        p.sendMessage(PlacementPlugin.getInstance().getPrefix() + "\u00a7aPlaceler selected: \u00a7f" + clicked.getItemMeta().getDisplayName());
    }
}

