/*
 * Decompiled with CFR 0.152.
 */
package com.klyroth.placement.placementPlugin.listener;

import com.klyroth.placement.placementPlugin.config.ConfigManager;
import com.klyroth.placement.placementPlugin.gui.GuiManager;
import com.klyroth.placement.placementPlugin.models.BlockChange;
import com.klyroth.placement.placementPlugin.models.ChangeOperation;
import com.klyroth.placement.placementPlugin.service.ContextService;
import com.klyroth.placement.placementPlugin.utils.BlockBatcher;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PlaceListener
implements Listener {
    private final ContextService ctx;
    private final ConfigManager cfg;
    private final BlockBatcher batcher;

    public PlaceListener(ContextService ctx, ConfigManager cfg, BlockBatcher batcher) {
        this.ctx = ctx;
        this.cfg = cfg;
        this.batcher = batcher;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        ItemStack hand = e.getItem();
        if (hand == null || hand.getType() != Material.BLAZE_ROD || hand.getItemMeta() == null || !hand.getItemMeta().getDisplayName().contains("Placeler") || e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Action action = e.getAction();
        if (action == Action.RIGHT_CLICK_BLOCK) {
            Block clicked = e.getClickedBlock();
            if (clicked == null || e.getBlockFace() != BlockFace.UP) {
                return;
            }
            e.setCancelled(true);
            UUID uid = p.getUniqueId();
            ItemStack toPlace = this.ctx.getPlaceler(uid);
            if (toPlace == null) {
                return;
            }
            Material placeMat = switch (toPlace.getType()) {
                case Material.WATER_BUCKET -> Material.WATER;
                case Material.LAVA_BUCKET -> Material.LAVA;
                default -> toPlace.getType();
            };
            Location base = clicked.getLocation().add(0.0, 1.0, 0.0);
            int r = this.ctx.getRadius(uid);
            ArrayList<Block> toSet = new ArrayList<Block>();
            ArrayList<BlockChange> oldState = new ArrayList<BlockChange>();
            if (r == 1) {
                Block b = base.getBlock();
                if (b.getType() == Material.AIR) {
                    oldState.add(new BlockChange(b.getWorld().getName(), b.getX(), b.getY(), b.getZ(), Material.AIR));
                    toSet.add(b);
                }
            } else {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        Block b = base.clone().add((double)x, 0.0, (double)z).getBlock();
                        if (b.getType() != Material.AIR) continue;
                        oldState.add(new BlockChange(b.getWorld().getName(), b.getX(), b.getY(), b.getZ(), Material.AIR));
                        toSet.add(b);
                    }
                }
            }
            this.batcher.applyBatch(toSet, placeMat);
            ChangeOperation op = new ChangeOperation(oldState, placeMat);
            this.ctx.pushOperation(uid, op);
            return;
        }
        if (action == Action.LEFT_CLICK_BLOCK || action == Action.LEFT_CLICK_AIR) {
            e.setCancelled(true);
            p.openInventory(new GuiManager(this.cfg).createFarmGui());
        }
    }
}

