/*
 * Decompiled with CFR 0.152.
 */
package com.klyroth.placement.placementPlugin.service;

import com.klyroth.placement.placementPlugin.config.ConfigManager;
import com.klyroth.placement.placementPlugin.models.ChangeOperation;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public class ContextService {
    private final Map<UUID, ItemStack> placelerMap = new HashMap<UUID, ItemStack>();
    private final Map<UUID, Integer> radiusMap = new HashMap<UUID, Integer>();
    private final ConfigManager cfg;
    private final Map<UUID, Deque<ChangeOperation>> undoStacks = new HashMap<UUID, Deque<ChangeOperation>>();
    private final Map<UUID, Deque<ChangeOperation>> redoStacks = new HashMap<UUID, Deque<ChangeOperation>>();

    public ContextService(ConfigManager cfg) {
        this.cfg = cfg;
    }

    public void setPlaceler(UUID player, ItemStack item) {
        this.placelerMap.put(player, item.clone());
        this.radiusMap.putIfAbsent(player, this.cfg.getDefaultRadius());
    }

    public ItemStack getPlaceler(UUID player) {
        return this.placelerMap.get(player);
    }

    public void clearPlaceler(UUID player) {
        this.placelerMap.remove(player);
        this.radiusMap.remove(player);
        this.undoStacks.remove(player);
        this.redoStacks.remove(player);
    }

    public void clearAll(UUID player) {
        this.clearPlaceler(player);
    }

    public void setRadius(UUID player, int radius) {
        this.radiusMap.put(player, radius);
    }

    public int getRadius(UUID player) {
        return this.radiusMap.getOrDefault(player, this.cfg.getDefaultRadius());
    }

    public void pushOperation(UUID player, ChangeOperation op) {
        this.undoStacks.computeIfAbsent(player, k -> new ArrayDeque()).push(op);
        Deque<ChangeOperation> rd = this.redoStacks.get(player);
        if (rd != null) {
            rd.clear();
        }
    }

    public boolean hasUndo(UUID player) {
        Deque<ChangeOperation> st = this.undoStacks.get(player);
        return st != null && !st.isEmpty();
    }

    public ChangeOperation popUndo(UUID player) {
        Deque<ChangeOperation> st = this.undoStacks.get(player);
        return st != null && !st.isEmpty() ? st.pop() : null;
    }

    public void pushRedo(UUID player, ChangeOperation op) {
        this.redoStacks.computeIfAbsent(player, k -> new ArrayDeque()).push(op);
    }

    public boolean hasRedo(UUID player) {
        Deque<ChangeOperation> st = this.redoStacks.get(player);
        return st != null && !st.isEmpty();
    }

    public ChangeOperation popRedo(UUID player) {
        Deque<ChangeOperation> st = this.redoStacks.get(player);
        return st != null && !st.isEmpty() ? st.pop() : null;
    }
}

