/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedrest;

import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.init.IRegistry;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.event.IntegratedDynamicsSetupEvent;
import org.cyclops.integrateddynamics.infobook.OnTheDynamicsOfIntegrationBook;
import org.cyclops.integratedrest.GeneralConfig;
import org.cyclops.integratedrest.RegistryEntries;
import org.cyclops.integratedrest.api.http.request.IRequestHandlerRegistry;
import org.cyclops.integratedrest.api.json.IValueTypeJsonHandlerRegistry;
import org.cyclops.integratedrest.block.BlockHttpConfig;
import org.cyclops.integratedrest.blockentity.BlockEntityHttpConfig;
import org.cyclops.integratedrest.client.model.HttpVariableModelProviders;
import org.cyclops.integratedrest.evaluate.HttpVariableFacadeHandler;
import org.cyclops.integratedrest.http.HttpServer;
import org.cyclops.integratedrest.http.request.RequestHandlerRegistry;
import org.cyclops.integratedrest.http.request.RequestHandlers;
import org.cyclops.integratedrest.inventory.container.ContainerHttpConfig;
import org.cyclops.integratedrest.json.ValueTypeJsonHandlerRegistry;
import org.cyclops.integratedrest.json.ValueTypeJsonHandlers;
import org.cyclops.integratedrest.proxy.ClientProxy;
import org.cyclops.integratedrest.proxy.CommonProxy;

@Mod(value="integratedrest")
public class IntegratedRest
extends ModBaseVersionable<IntegratedRest> {
    public static IntegratedRest _instance;
    protected final HttpServer server = new HttpServer();

    public IntegratedRest(IEventBus modEventBus) {
        super("integratedrest", instance -> {
            _instance = instance;
        }, modEventBus);
        this.getRegistryManager().addRegistry(IRequestHandlerRegistry.class, (IRegistry)RequestHandlerRegistry.getInstance());
        this.getRegistryManager().addRegistry(IValueTypeJsonHandlerRegistry.class, (IRegistry)ValueTypeJsonHandlerRegistry.getInstance());
        NeoForge.EVENT_BUS.addListener(this::onApiServerStarted);
        NeoForge.EVENT_BUS.addListener(this::onApiServerStopping);
        modEventBus.addListener(this::onSetup);
    }

    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        if (MinecraftHelpers.isClientSide()) {
            HttpVariableModelProviders.load();
        }
    }

    protected void onSetup(IntegratedDynamicsSetupEvent event) {
        ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).registerHandler((IVariableFacadeHandler)HttpVariableFacadeHandler.getInstance());
        RequestHandlers.load();
        ValueTypeJsonHandlers.load();
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBase)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.manual", "/data/integratedrest/info/rest_info.xml");
    }

    public void onApiServerStarted(ServerStartedEvent event) {
        if (GeneralConfig.startApi) {
            this.server.initialize();
        }
    }

    public void onApiServerStopping(ServerStoppingEvent event) {
        if (GeneralConfig.startApi) {
            this.server.deinitialize();
        }
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).icon(() -> new ItemStack(RegistryEntries.ITEM_BLOCK_HTTP));
    }

    protected void onConfigsRegister(ConfigHandler configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfig)new GeneralConfig());
        configHandler.addConfigurable((ExtendedConfig)new BlockHttpConfig());
        configHandler.addConfigurable((ExtendedConfig)new BlockEntityHttpConfig());
        configHandler.addConfigurable((ExtendedConfig)new ContainerHttpConfig());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    public static void clog(String message) {
        IntegratedRest.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }
}

