/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedrest.http;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integratedrest.Uris;
import org.cyclops.integratedrest.api.http.request.IRequestHandler;
import org.cyclops.integratedrest.http.request.RequestHandlers;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpHeaderNames;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpRequest;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpResponseStatus;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpUtil;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpVersion;

public class HttpServerHandler
extends SimpleChannelInboundHandler<Object> {
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext context, Object message) throws Exception {
        if (message instanceof HttpRequest) {
            Gson gson;
            String responseString;
            HttpResponseStatus responseStatus;
            HttpRequest request = (HttpRequest)message;
            if (HttpUtil.is100ContinueExpected(request)) {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
                context.write((Object)response);
            }
            JsonObject responseObject = new JsonObject();
            responseObject.addProperty("@context", Uris.IT + "context.jsonld");
            Object[] path = request.uri().substring(1).split("/");
            List paths = Lists.newArrayList();
            while (path.length > 1) {
                paths.add(path);
                String prefix = path[0];
                path = (String[])ArrayUtils.subarray((Object[])path, (int)1, (int)path.length);
                path[0] = prefix + "/" + (String)path[0];
            }
            paths.add(path);
            paths = Lists.reverse((List)paths);
            IRequestHandler requestHandler = null;
            for (String[] pathArray : paths) {
                requestHandler = RequestHandlers.REGISTRY.getHandler(pathArray[0]);
                if (requestHandler == null) continue;
                path = pathArray;
                break;
            }
            if (requestHandler == null) {
                responseStatus = HttpResponseStatus.NOT_FOUND;
            } else {
                BlockEntityHelpers.UNSAFE_BLOCK_ENTITY_GETTER = true;
                IModHelpersNeoForge.get().getBlockEntityHelpers().setUnsafeBlockEntityGetter(true);
                responseStatus = requestHandler.handle((String[])ArrayUtils.subarray((Object[])path, (int)1, (int)path.length), request, responseObject);
                BlockEntityHelpers.UNSAFE_BLOCK_ENTITY_GETTER = false;
                IModHelpersNeoForge.get().getBlockEntityHelpers().setUnsafeBlockEntityGetter(false);
            }
            if (responseStatus == HttpResponseStatus.NOT_FOUND) {
                responseObject.addProperty("error", "Resource was not found.");
            }
            if (!this.writeResponse(request, context, responseString = (gson = new GsonBuilder().setPrettyPrinting().create()).toJson((JsonElement)responseObject) + "\n", responseStatus)) {
                context.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }

    private boolean writeResponse(HttpRequest request, ChannelHandlerContext context, String responseString, HttpResponseStatus responseStatus) {
        boolean keepAlive = HttpUtil.isKeepAlive(request);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.copiedBuffer((CharSequence)responseString, (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/ld+json");
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
        if (keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"keep-alive");
        }
        context.write((Object)response);
        return keepAlive;
    }
}

