/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedrest.http.request.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.netty.util.CharsetUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPositionedNetworkElement;
import org.cyclops.integratedrest.blockentity.BlockEntityHttp;
import org.cyclops.integratedrest.http.request.handler.ElementTypeRequestHandler;
import org.cyclops.integratedrest.json.JsonUtil;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpContent;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpMethod;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpRequest;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpResponseStatus;

public class ElementHttpRequestHandler
extends ElementTypeRequestHandler {
    @Override
    @Nullable
    protected HttpResponseStatus handleElement(int id, INetwork network, INetworkElement networkElement, HttpRequest request, JsonObject responseObject) {
        IPositionedNetworkElement positionedNetworkElement;
        BlockEntityHttp tile;
        if (networkElement instanceof IPositionedNetworkElement && (tile = (BlockEntityHttp)BlockEntityHelpers.get((DimPos)(positionedNetworkElement = (IPositionedNetworkElement)networkElement).getPosition(), BlockEntityHttp.class).orElse(null)) != null && tile.getProxyId() == id) {
            if (request.method().equals(HttpMethod.GET)) {
                JsonUtil.addNetworkElementInfo(responseObject, networkElement, network);
                responseObject.addProperty("http://www.w3.org/ns/ldp#inbox", responseObject.get("@id").getAsString());
                return HttpResponseStatus.OK;
            }
            if (request.method().equals(HttpMethod.POST) && request instanceof HttpContent) {
                String content = ((HttpContent)((Object)request)).content().toString(CharsetUtil.UTF_8);
                try {
                    JsonObject jsonObject = JsonParser.parseString((String)content).getAsJsonObject();
                    JsonElement jsonElement = jsonObject.get("value");
                    if (jsonElement == null) {
                        responseObject.addProperty("error", "No value property was found in the root object.");
                        return HttpResponseStatus.BAD_REQUEST;
                    }
                    Optional<IValue> valueOptional = JsonUtil.jsonToValue(jsonElement);
                    if (valueOptional.isPresent()) {
                        IValue value = valueOptional.get();
                        if (!tile.getValueType().correspondsTo(value.getType())) {
                            responseObject.addProperty("error", "Invalid value type, HTTP Proxy expects " + tile.getValueType().getTypeName() + " but " + value.getType().getTypeName() + " was given.");
                            return HttpResponseStatus.BAD_REQUEST;
                        }
                    } else {
                        responseObject.addProperty("error", "No valid value was given.");
                        return HttpResponseStatus.BAD_REQUEST;
                    }
                    tile.setValue(valueOptional.get());
                }
                catch (JsonSyntaxException | ClassCastException e) {
                    responseObject.addProperty("error", e.getMessage());
                    return HttpResponseStatus.BAD_REQUEST;
                }
                responseObject.addProperty("ok", "Value was successfully updated.");
                return HttpResponseStatus.OK;
            }
            return HttpResponseStatus.METHOD_NOT_ALLOWED;
        }
        return null;
    }
}

