/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedrest.http.request.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.IIdentifiableNetworkElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;
import org.cyclops.integratedrest.api.http.request.IRequestHandler;
import org.cyclops.integratedrest.json.JsonUtil;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpMethod;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpRequest;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpResponseStatus;

public class ElementRequestHandler
implements IRequestHandler {
    @Override
    public HttpResponseStatus handle(String[] path, HttpRequest request, JsonObject responseObject) {
        NetworkWorldStorage worldStorage = NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance);
        if (path.length == 0) {
            if (!request.method().equals(HttpMethod.GET)) {
                return HttpResponseStatus.BAD_REQUEST;
            }
            JsonArray jsonParts = new JsonArray();
            for (INetwork network : worldStorage.getNetworks()) {
                for (INetworkElement element : network.getElements()) {
                    JsonObject jsonElement = new JsonObject();
                    JsonUtil.addNetworkElementInfo(jsonElement, element, network);
                    jsonParts.add((JsonElement)jsonElement);
                }
            }
            responseObject.addProperty("@id", JsonUtil.absolutizePath("/"));
            responseObject.add("networkElements", (JsonElement)jsonParts);
            return HttpResponseStatus.OK;
        }
        if (path.length >= 2) {
            String groupPath = String.join((CharSequence)"/", (CharSequence[])ArrayUtils.subarray((Object[])path, (int)0, (int)(path.length - 1)));
            try {
                int id = Integer.parseInt(path[path.length - 1]);
                for (INetwork network : worldStorage.getNetworks()) {
                    for (INetworkElement element : network.getElements()) {
                        HttpResponseStatus status = this.handleElement(groupPath, id, network, element, request, responseObject);
                        if (status == null) continue;
                        return status;
                    }
                }
            }
            catch (NumberFormatException e) {
                return HttpResponseStatus.BAD_REQUEST;
            }
        }
        return HttpResponseStatus.NOT_FOUND;
    }

    @Nullable
    protected HttpResponseStatus handleElement(String groupPath, int id, INetwork network, INetworkElement networkElement, HttpRequest request, JsonObject responseObject) {
        if (networkElement instanceof IIdentifiableNetworkElement && ((IIdentifiableNetworkElement)networkElement).getId() == id && JsonUtil.resourceLocationToPath(((IIdentifiableNetworkElement)networkElement).getGroup()).equals(groupPath)) {
            JsonUtil.addNetworkElementInfo(responseObject, networkElement, network);
            return HttpResponseStatus.OK;
        }
        return null;
    }
}

