/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedrest.http.request.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integratedrest.api.http.request.IRequestHandler;
import org.cyclops.integratedrest.json.JsonUtil;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpRequest;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpResponseStatus;

public abstract class RegistryNamespacedRequestHandler<T>
implements IRequestHandler {
    protected abstract Registry<T> getRegistry();

    protected abstract void handleElement(T var1, JsonObject var2);

    protected abstract String getElementsName();

    @Override
    public HttpResponseStatus handle(String[] path, HttpRequest request, JsonObject responseObject) {
        Registry<T> registry = this.getRegistry();
        if (path.length == 0) {
            JsonArray array = new JsonArray();
            for (Object element : registry) {
                JsonObject object = new JsonObject();
                this.handleElement(element, object);
                array.add((JsonElement)object);
            }
            responseObject.addProperty("@id", JsonUtil.absolutizePath("/"));
            responseObject.add(this.getElementsName(), (JsonElement)array);
            return HttpResponseStatus.OK;
        }
        ResourceLocation resourceLocation = RegistryNamespacedRequestHandler.pathToResourceLocation(path);
        Object element = registry.get(resourceLocation);
        if (element != null) {
            this.handleElement(element, responseObject);
            return HttpResponseStatus.OK;
        }
        return HttpResponseStatus.NOT_FOUND;
    }

    public static ResourceLocation pathToResourceLocation(String[] path) {
        return ResourceLocation.parse((String)String.join((CharSequence)"/", path).replaceFirst("\\/", ":"));
    }
}

