/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedrest.inventory.container;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.slot.SlotRemoveOnly;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerActiveVariableBase;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integratedrest.RegistryEntries;
import org.cyclops.integratedrest.blockentity.BlockEntityHttp;

public class ContainerHttp
extends ContainerActiveVariableBase<BlockEntityHttp> {
    private final int valueTypeId;

    public ContainerHttp(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(2), Optional.empty());
    }

    public ContainerHttp(int id, Inventory playerInventory, Container inventory, Optional<BlockEntityHttp> tileSupplier) {
        super((MenuType)RegistryEntries.CONTAINER_HTTP.get(), id, playerInventory, inventory, tileSupplier);
        this.addSlot((Slot)new SlotVariable(inventory, 0, 56, 63));
        this.addSlot((Slot)new SlotRemoveOnly(inventory, 1, 104, 63));
        this.addPlayerInventory(playerInventory, this.offsetX + 9, this.offsetY + 92);
        this.valueTypeId = this.getNextValueId();
        this.getTileSupplier().ifPresent(tile -> tile.setLastPlayer(playerInventory.player));
    }

    protected void initializeValues() {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.getValueTypeId(), (String)((BlockEntityHttp)((Object)this.getTileSupplier().get())).getValueType().getUniqueName().toString());
    }

    public int getValueTypeId() {
        return this.valueTypeId;
    }

    public Optional<IValueType> getValueType() {
        String id = ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)this.getValueTypeId());
        return id == null ? Optional.empty() : Optional.of(Objects.requireNonNull(ValueTypes.REGISTRY.getValueType(ResourceLocation.parse((String)id)), id));
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        if (this.getTileSupplier().isPresent() && valueId == this.getValueTypeId()) {
            this.getValueType().ifPresent(vt -> ((BlockEntityHttp)((Object)((Object)this.getTileSupplier().get()))).setValueType((IValueType)vt));
        }
    }
}

