/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedrest.blockentity;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.expression.VariableAdapter;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.blockentity.BlockEntityProxy;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integratedrest.RegistryEntries;
import org.cyclops.integratedrest.api.item.IHttpVariableFacade;
import org.cyclops.integratedrest.evaluate.HttpVariableFacadeHandler;
import org.cyclops.integratedrest.inventory.container.ContainerHttp;
import org.cyclops.integratedrest.item.HttpVariableFacade;
import org.cyclops.integratedrest.network.HttpNetworkElement;

public class BlockEntityHttp
extends BlockEntityProxy {
    public static final int INVENTORY_SIZE = 2;
    public static final int SLOT_WRITE_IN = 0;
    public static final int SLOT_WRITE_OUT = 1;
    private final HttpVariableAdapter variable = new HttpVariableAdapter(this, (IValueType)ValueTypes.CATEGORY_ANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
    private Player lastPlayer = null;

    public BlockEntityHttp(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_HTTP.get(), blockPos, blockState, 2);
    }

    public void setLastPlayer(Player lastPlayer) {
        this.lastPlayer = lastPlayer;
    }

    public INetworkElementProvider getNetworkElementProvider() {
        return new NetworkElementProviderSingleton(this){

            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new HttpNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        };
    }

    public ItemStack writeProxyInfo(boolean generateId, ItemStack itemStack, final int proxyId) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(generateId, itemStack, (IVariableFacadeHandler)HttpVariableFacadeHandler.getInstance(), (IVariableFacadeHandlerRegistry.IVariableFacadeFactory)new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IHttpVariableFacade>(this){

            public IHttpVariableFacade create(boolean generateId) {
                return new HttpVariableFacade(generateId, proxyId);
            }

            public IHttpVariableFacade create(int id) {
                return new HttpVariableFacade(id, proxyId);
            }
        }, this.getLevel(), this.lastPlayer, this.getBlockState());
    }

    public IVariable<?> getVariable(IPartNetwork network) {
        return this.variable;
    }

    public int getSlotRead() {
        return -1;
    }

    protected int getSlotWriteIn() {
        return 0;
    }

    protected int getSlotWriteOut() {
        return 1;
    }

    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putString("valueType", this.variable.getValueTypeRaw().getUniqueName().toString());
        if (this.variable.getValueRaw() != null) {
            ValueHelpers.serialize((ValueOutput)output.child("value"), (IValue)this.variable.getValueRaw());
        }
    }

    public void read(ValueInput input) {
        super.read(input);
        this.variable.setValueTypeRaw(ValueTypes.REGISTRY.getValueType(ResourceLocation.parse((String)((String)input.getString("valueType").orElseThrow()))));
        input.child("value").ifPresent(value -> this.setValue(ValueHelpers.deserialize((ValueInput)value)));
    }

    public IValueType<IValue> getValueType() {
        return this.variable.getValueTypeRaw();
    }

    public void setValueType(IValueType valueType) {
        this.variable.setValueTypeRaw(valueType);
        if (!valueType.isCategory()) {
            this.setValue(valueType.getDefault());
        } else {
            this.setValue((IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
        }
        this.sendUpdate();
    }

    public void setValue(IValue value) {
        this.variable.invalidate();
        this.variable.setValueRaw(value);
        this.sendUpdate();
    }

    public boolean hasVariable() {
        return this.variable.getValueRaw() != null;
    }

    protected void updateReadVariable(boolean sendVariablesUpdateEvent) {
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerHttp(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.integratedrest.http");
    }

    public static class HttpVariableAdapter
    extends VariableAdapter {
        private final BlockEntityHttp tile;
        private IValueType valueType;
        private IValue value;

        public HttpVariableAdapter(BlockEntityHttp tile, IValueType valueType, IValue value) {
            this.tile = tile;
            this.valueType = valueType;
            this.value = value;
        }

        @Nullable
        public IValue getValueRaw() {
            return this.value;
        }

        public IValueType getValueTypeRaw() {
            return this.valueType;
        }

        public void setValueRaw(IValue value) {
            this.value = value;
        }

        public void setValueTypeRaw(IValueType valueType) {
            this.valueType = valueType;
        }

        public IValueType getType() {
            return this.valueType;
        }

        public IValue getValue() throws EvaluationException {
            if (this.value == null) {
                throw new EvaluationException(Component.translatable((String)"http.integratedrest.error.http_invalid", (Object[])new Object[]{this.tile.getProxyId()}));
            }
            return this.value;
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityCableConnectableInventory.CapabilityRegistrar<BlockEntityHttp> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityHttp>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            super.populate();
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> {
                int slot = -1;
                switch (direction) {
                    case DOWN: {
                        slot = 1;
                        break;
                    }
                    case UP: {
                        slot = 0;
                        break;
                    }
                    case NORTH: {
                        slot = 0;
                        break;
                    }
                    case SOUTH: {
                        slot = 0;
                        break;
                    }
                    case WEST: {
                        slot = 0;
                        break;
                    }
                    case EAST: {
                        slot = 0;
                    }
                }
                return new ItemHandlerSlotMasked((Container)blockEntity.getInventory(), new int[]{slot});
            });
            this.add(Capabilities.NetworkElementProvider.BLOCK, (blockEntity, direction) -> blockEntity.getNetworkElementProvider());
        }
    }
}

