/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedrest.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.logging.log4j.Level;
import org.cyclops.integratedrest.GeneralConfig;
import org.cyclops.integratedrest.IntegratedRest;
import org.cyclops.integratedrest.http.HttpServerInitializer;

public class HttpServer {
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;

    public Channel getChannel() {
        return this.channel;
    }

    public void initialize() {
        IntegratedRest.clog(Level.INFO, "Starting Integrated REST server...");
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpServerInitializer());
        try {
            this.channel = b.bind(GeneralConfig.apiPort).sync().channel();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        IntegratedRest.clog(Level.INFO, "Started Integrated REST server on http://localhost:" + GeneralConfig.apiPort + "/");
    }

    public void deinitialize() {
        IntegratedRest.clog(Level.INFO, "Stopping Integrated REST server...");
        if (this.bossGroup != null && this.workerGroup != null) {
            try {
                this.bossGroup.shutdownGracefully().sync();
                this.workerGroup.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        IntegratedRest.clog(Level.INFO, "Stopped Integrated REST server");
    }
}

